/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.versioned.GlCompat;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.BoxElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.TextStencilElement;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widgets.BoxWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.FramebufferConstants;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import org.lwjgl.opengl.GL11;

public class ConfirmationScreen
extends AbstractSimiScreen {
    private Screen source;
    private Consumer<Response> action = _success -> {};
    private List<ITextProperties> text = new ArrayList<ITextProperties>();
    private boolean centered = false;
    private int x;
    private int y;
    private int textWidth;
    private int textHeight;
    private boolean tristate;
    private BoxWidget confirm;
    private BoxWidget confirmDontSave;
    private BoxWidget cancel;
    private BoxElement textBackground;

    public ConfirmationScreen removeTextLines(int amount) {
        if (amount > this.text.size()) {
            return this.clearText();
        }
        this.text.subList(this.text.size() - amount, this.text.size()).clear();
        return this;
    }

    public ConfirmationScreen clearText() {
        this.text.clear();
        return this;
    }

    public ConfirmationScreen addText(ITextProperties text) {
        this.text.add(text);
        return this;
    }

    public ConfirmationScreen withText(ITextProperties text) {
        return this.clearText().addText(text);
    }

    public ConfirmationScreen at(int x, int y) {
        this.x = Math.max(x, 0);
        this.y = Math.max(y, 0);
        this.centered = false;
        return this;
    }

    public ConfirmationScreen centered() {
        this.centered = true;
        return this;
    }

    public ConfirmationScreen withAction(Consumer<Boolean> action) {
        this.action = r -> action.accept(r == Response.Confirm);
        return this;
    }

    public ConfirmationScreen withThreeActions(Consumer<Response> action) {
        this.action = action;
        this.tristate = true;
        return this;
    }

    public void open(@Nonnull Screen source) {
        this.source = source;
        Minecraft client = source.getMinecraft();
        this.func_231158_b_(client, client.func_228018_at_().func_198107_o(), client.func_228018_at_().func_198087_p());
        this.field_230706_i_.field_71462_r = this;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.confirm.tick();
        this.cancel.tick();
    }

    @Override
    protected void func_231160_c_() {
        this.widgets.clear();
        ArrayList<ITextProperties> copy = new ArrayList<ITextProperties>(this.text);
        this.text.clear();
        copy.forEach(t -> this.text.addAll(this.field_230706_i_.field_71466_p.func_238420_b_().func_238362_b_(t, 300, Style.field_240709_b_)));
        int n = this.text.size();
        this.field_230706_i_.field_71466_p.getClass();
        this.textHeight = n * (9 + 1) + 4;
        this.textWidth = 300;
        if (this.centered) {
            this.x = this.field_230708_k_ / 2 - this.textWidth / 2 - 2;
            this.y = this.field_230709_l_ / 2 - this.textHeight / 2 - 16;
        } else {
            this.x = Math.max(0, this.x - this.textWidth / 2);
            this.y = Math.max(0, this.y -= this.textHeight);
        }
        if (this.x + this.textWidth > this.field_230708_k_) {
            this.x = this.field_230708_k_ - this.textWidth;
        }
        if (this.y + this.textHeight + 30 > this.field_230709_l_) {
            this.y = this.field_230709_l_ - this.textHeight - 30;
        }
        int buttonX = this.x + this.textWidth / 2 - 6 - (int)(70.0f * (this.tristate ? 1.5f : 1.0f));
        TextStencilElement confirmText = new TextStencilElement(this.field_230706_i_.field_71466_p, this.tristate ? "Save" : "Confirm").centered(true, true);
        this.confirm = (BoxWidget)((Object)new BoxWidget(buttonX, this.y + this.textHeight + 6, 70, 16).withCallback(() -> this.accept(Response.Confirm)));
        this.confirm.showingElement((RenderElement)confirmText.withElementRenderer(BoxWidget.gradientFactory.apply(this.confirm)));
        this.widgets.add(this.confirm);
        buttonX += 82;
        if (this.tristate) {
            TextStencilElement confirmDontSaveText = new TextStencilElement(this.field_230706_i_.field_71466_p, "Don't Save").centered(true, true);
            this.confirmDontSave = (BoxWidget)((Object)new BoxWidget(buttonX, this.y + this.textHeight + 6, 70, 16).withCallback(() -> this.accept(Response.ConfirmDontSave)));
            this.confirmDontSave.showingElement((RenderElement)confirmDontSaveText.withElementRenderer(BoxWidget.gradientFactory.apply(this.confirmDontSave)));
            this.widgets.add(this.confirmDontSave);
            buttonX += 82;
        }
        TextStencilElement cancelText = new TextStencilElement(this.field_230706_i_.field_71466_p, "Cancel").centered(true, true);
        this.cancel = (BoxWidget)((Object)new BoxWidget(buttonX, this.y + this.textHeight + 6, 70, 16).withCallback(() -> this.accept(Response.Cancel)));
        this.cancel.showingElement((RenderElement)cancelText.withElementRenderer(BoxWidget.gradientFactory.apply(this.cancel)));
        this.widgets.add(this.cancel);
        this.textBackground = (BoxElement)((RenderElement)((RenderElement)new BoxElement().gradientBorder(Theme.p(Theme.Key.BUTTON_DISABLE))).withBounds(this.field_230708_k_ + 10, this.textHeight + 35)).at(-5.0f, this.y - 5);
    }

    public void func_231175_as__() {
        this.accept(Response.Cancel);
    }

    private void accept(Response success) {
        this.field_230706_i_.field_71462_r = this.source;
        this.action.accept(success);
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.textBackground.render(ms);
        this.field_230706_i_.field_71466_p.getClass();
        int offset = 9 + 1;
        int lineY = this.y - offset;
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, 200.0);
        for (ITextProperties line : this.text) {
            lineY += offset;
            if (line == null) continue;
            int textX = this.x;
            if (this.text.size() == 1) {
                this.x = (this.field_230708_k_ - this.field_230706_i_.field_71466_p.func_238414_a_(line)) / 2;
            }
            this.field_230706_i_.field_71466_p.func_238421_b_(ms, line.getString(), (float)textX, (float)lineY, 0xEAEAEA);
        }
        ms.func_227865_b_();
    }

    @Override
    protected void renderWindowBackground(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.endFrame();
        this.source.func_230430_a_(ms, 0, 0, 10.0f);
        this.prepareFrame();
        this.func_238468_a_(ms, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x70101010, -2146430960);
    }

    @Override
    protected void prepareFrame() {
        Framebuffer thisBuffer = UIRenderHelper.framebuffer;
        Framebuffer mainBuffer = Minecraft.func_71410_x().func_147110_a();
        GlCompat functions = Backend.getInstance().compat;
        functions.fbo.bindFramebuffer(36008, mainBuffer.field_147616_f);
        functions.fbo.bindFramebuffer(36009, thisBuffer.field_147616_f);
        functions.blit.blitFramebuffer(0, 0, mainBuffer.field_147621_c, mainBuffer.field_147618_d, 0, 0, mainBuffer.field_147621_c, mainBuffer.field_147618_d, 16384, 9729);
        functions.fbo.bindFramebuffer(FramebufferConstants.field_227592_a_, thisBuffer.field_147616_f);
        GL11.glClear((int)1280);
    }

    @Override
    protected void endFrame() {
        Framebuffer thisBuffer = UIRenderHelper.framebuffer;
        Framebuffer mainBuffer = Minecraft.func_71410_x().func_147110_a();
        GlCompat functions = Backend.getInstance().compat;
        functions.fbo.bindFramebuffer(36008, thisBuffer.field_147616_f);
        functions.fbo.bindFramebuffer(36009, mainBuffer.field_147616_f);
        functions.blit.blitFramebuffer(0, 0, mainBuffer.field_147621_c, mainBuffer.field_147618_d, 0, 0, mainBuffer.field_147621_c, mainBuffer.field_147618_d, 16384, 9729);
        functions.fbo.bindFramebuffer(FramebufferConstants.field_227592_a_, mainBuffer.field_147616_f);
    }

    public void func_231152_a_(@Nonnull Minecraft client, int width, int height) {
        super.func_231152_a_(client, width, height);
        this.source.func_231152_a_(client, width, height);
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    public static enum Response {
        Confirm,
        ConfirmDontSave,
        Cancel;

    }
}

