/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.fluid;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class FluidRenderer {
    public static IVertexBuilder getFluidBuilder(IRenderTypeBuffer buffer) {
        return buffer.getBuffer(RenderTypes.getFluid());
    }

    public static void renderFluidStream(FluidStack fluidStack, Direction direction, float radius, float progress, boolean inbound, IRenderTypeBuffer buffer, MatrixStack ms, int light) {
        FluidRenderer.renderFluidStream(fluidStack, direction, radius, progress, inbound, FluidRenderer.getFluidBuilder(buffer), ms, light);
    }

    public static void renderFluidStream(FluidStack fluidStack, Direction direction, float radius, float progress, boolean inbound, IVertexBuilder builder, MatrixStack ms, int light) {
        float y;
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes fluidAttributes = fluid.getAttributes();
        Function spriteAtlas = Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_);
        TextureAtlasSprite flowTexture = (TextureAtlasSprite)spriteAtlas.apply(fluidAttributes.getFlowingTexture(fluidStack));
        TextureAtlasSprite stillTexture = (TextureAtlasSprite)spriteAtlas.apply(fluidAttributes.getStillTexture(fluidStack));
        int color = fluidAttributes.getColor(fluidStack);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLuminosity(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        if (inbound) {
            direction = direction.func_176734_d();
        }
        MatrixTransformStack msr = MatrixTransformStack.of((MatrixStack)ms);
        ms.func_227860_a_();
        msr.centre().rotateY((double)AngleHelper.horizontalAngle(direction)).rotateX(direction == Direction.UP ? 0.0 : (direction == Direction.DOWN ? 180.0 : 90.0)).unCentre();
        ms.func_227861_a_(0.5, 0.0, 0.5);
        float h = radius;
        float hMin = -radius;
        float hMax = radius;
        float yMin = y = inbound ? 0.0f : 0.5f;
        float yMax = y + MathHelper.func_76131_a((float)(progress * 0.5f - 1.0E-6f), (float)0.0f, (float)1.0f);
        for (int i = 0; i < 4; ++i) {
            ms.func_227860_a_();
            FluidRenderer.renderTiledHorizontalFace(h, Direction.SOUTH, hMin, yMin, hMax, yMax, builder, ms, light, color, flowTexture);
            ms.func_227865_b_();
            msr.rotateY(90.0);
        }
        if (progress != 1.0f) {
            FluidRenderer.renderTiledVerticalFace(yMax, Direction.UP, hMin, hMin, hMax, hMax, builder, ms, light, color, stillTexture);
        }
        ms.func_227865_b_();
    }

    public static void renderTiledFluidBB(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, IRenderTypeBuffer buffer, MatrixStack ms, int light, boolean renderBottom) {
        FluidRenderer.renderTiledFluidBB(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderer.getFluidBuilder(buffer), ms, light, renderBottom);
    }

    public static void renderTiledFluidBB(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, IVertexBuilder builder, MatrixStack ms, int light, boolean renderBottom) {
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes fluidAttributes = fluid.getAttributes();
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidAttributes.getStillTexture(fluidStack));
        int color = fluidAttributes.getColor(fluidStack);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLuminosity(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        Vector3d center = new Vector3d((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        MatrixTransformStack msr = MatrixTransformStack.of((MatrixStack)ms);
        ms.func_227860_a_();
        if (fluidStack.getFluid().getAttributes().isLighterThanAir()) {
            MatrixTransformStack.of((MatrixStack)ms).translate(center).rotateX(180.0).translateBack(center);
        }
        for (Direction side : Iterate.directions) {
            if (side == Direction.DOWN && !renderBottom) continue;
            if (side.func_176740_k().func_176722_c()) {
                ms.func_227860_a_();
                if (side.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
                    msr.translate(center).rotateY(180.0).translateBack(center);
                }
                boolean X = side.func_176740_k() == Direction.Axis.X;
                int darkColor = Color.mixColors(color, -16777199, 0.25f);
                FluidRenderer.renderTiledHorizontalFace(X ? xMax : zMax, side, X ? zMin : xMin, yMin, X ? zMax : xMax, yMax, builder, ms, light, darkColor, fluidTexture);
                ms.func_227865_b_();
                continue;
            }
            FluidRenderer.renderTiledVerticalFace(side == Direction.UP ? yMax : yMin, side, xMin, zMin, xMax, zMax, builder, ms, light, color, fluidTexture);
        }
        ms.func_227865_b_();
    }

    private static void renderTiledVerticalFace(float y, Direction face, float xMin, float zMin, float xMax, float zMax, IVertexBuilder builder, MatrixStack ms, int light, int color, TextureAtlasSprite texture) {
        float x2 = 0.0f;
        float z2 = 0.0f;
        float x1 = xMin;
        while (x1 < xMax) {
            x2 = Math.min((float)((int)(x1 + 1.0f)), xMax);
            float z1 = zMin;
            while (z1 < zMax) {
                z2 = Math.min((float)((int)(z1 + 1.0f)), zMax);
                float u1 = texture.func_94214_a((double)(FluidRenderer.local(x1) * 16.0f));
                float v1 = texture.func_94207_b((double)(FluidRenderer.local(z1) * 16.0f));
                float u2 = texture.func_94214_a(x2 == xMax ? (double)(FluidRenderer.local(x2) * 16.0f) : 16.0);
                float v2 = texture.func_94207_b(z2 == zMax ? (double)(FluidRenderer.local(z2) * 16.0f) : 16.0);
                FluidRenderer.putVertex(builder, ms, x1, y, z2, color, u1, v2, face, light);
                FluidRenderer.putVertex(builder, ms, x2, y, z2, color, u2, v2, face, light);
                FluidRenderer.putVertex(builder, ms, x2, y, z1, color, u2, v1, face, light);
                FluidRenderer.putVertex(builder, ms, x1, y, z1, color, u1, v1, face, light);
                z1 = z2;
            }
            x1 = x2;
        }
    }

    private static void renderTiledHorizontalFace(float h, Direction face, float hMin, float yMin, float hMax, float yMax, IVertexBuilder builder, MatrixStack ms, int light, int color, TextureAtlasSprite texture) {
        boolean X = face.func_176740_k() == Direction.Axis.X;
        float h2 = 0.0f;
        float y2 = 0.0f;
        float h1 = hMin;
        while (h1 < hMax) {
            h2 = Math.min((float)((int)(h1 + 1.0f)), hMax);
            float y1 = yMin;
            while (y1 < yMax) {
                y2 = Math.min((float)((int)(y1 + 1.0f)), yMax);
                int multiplier = texture.func_94211_a() == 32 ? 8 : 16;
                float u1 = texture.func_94214_a((double)(FluidRenderer.local(h1) * (float)multiplier));
                float v1 = texture.func_94207_b((double)(FluidRenderer.local(y1) * (float)multiplier));
                float u2 = texture.func_94214_a(h2 == hMax ? (double)(FluidRenderer.local(h2) * (float)multiplier) : (double)multiplier);
                float v2 = texture.func_94207_b(y2 == yMax ? (double)(FluidRenderer.local(y2) * (float)multiplier) : (double)multiplier);
                float x1 = X ? h : h1;
                float x2 = X ? h : h2;
                float z1 = X ? h1 : h;
                float z2 = X ? h2 : h;
                FluidRenderer.putVertex(builder, ms, x2, y2, z1, color, u1, v2, face, light);
                FluidRenderer.putVertex(builder, ms, x1, y2, z2, color, u2, v2, face, light);
                FluidRenderer.putVertex(builder, ms, x1, y1, z2, color, u2, v1, face, light);
                FluidRenderer.putVertex(builder, ms, x2, y1, z1, color, u1, v1, face, light);
                y1 = y2;
            }
            h1 = h2;
        }
    }

    private static float local(float f) {
        if (f < 0.0f) {
            f += 10.0f;
        }
        return f - (float)((int)f);
    }

    private static void putVertex(IVertexBuilder builder, MatrixStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vector3i n = face.func_176730_m();
        MatrixStack.Entry peek = ms.func_227866_c_();
        int ff = 255;
        int a = color >> 24 & ff;
        int r = color >> 16 & ff;
        int g = color >> 8 & ff;
        int b = color & ff;
        builder.func_227888_a_(peek.func_227870_a_(), x, y, z).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_((float)n.func_177958_n(), (float)n.func_177956_o(), (float)n.func_177952_p()).func_181675_d();
    }
}

