/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.simibubi.create.foundation.advancement.StringSerializableTrigger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnumTrigger<T extends Enum<T>>
extends StringSerializableTrigger<T> {
    private final Class<T> reference;

    public EnumTrigger(String id, Class<T> reference) {
        super(id);
        this.reference = reference;
    }

    @Override
    @Nullable
    protected T getValue(String key) {
        try {
            return Enum.valueOf(this.reference, key);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    @Override
    @Nullable
    protected String getKey(@Nullable T value) {
        if (value == null) {
            return null;
        }
        return ((Enum)value).name();
    }
}

