/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.google.gson.JsonParseException;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class ItemNameAttribute
implements ItemAttribute {
    String itemName;

    public ItemNameAttribute(String itemName) {
        this.itemName = itemName;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.extractCustomName(itemStack).equals(this.itemName);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        String name = this.extractCustomName(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (name.length() > 0) {
            atts.add(new ItemNameAttribute(name));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        return "has_name";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.itemName};
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        nbt.func_74778_a("name", this.itemName);
    }

    @Override
    public ItemAttribute readNBT(CompoundNBT nbt) {
        return new ItemNameAttribute(nbt.func_74779_i("name"));
    }

    private String extractCustomName(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_179543_a("display");
        if (compoundnbt != null && compoundnbt.func_150297_b("Name", 8)) {
            try {
                IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_((String)compoundnbt.func_74779_i("Name"));
                if (itextcomponent != null) {
                    return itextcomponent.getString();
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return "";
    }
}

