/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FunnelMovementBehaviour
extends MovementBehaviour {
    private final boolean hasFilter;

    public static FunnelMovementBehaviour andesite() {
        return new FunnelMovementBehaviour(false);
    }

    public static FunnelMovementBehaviour brass() {
        return new FunnelMovementBehaviour(true);
    }

    private FunnelMovementBehaviour(boolean hasFilter) {
        this.hasFilter = hasFilter;
    }

    @Override
    public Vector3d getActiveAreaOffset(MovementContext context) {
        Direction facing = FunnelBlock.getFunnelFacing(context.state);
        Vector3d vec = Vector3d.func_237491_b_((Vector3i)facing.func_176730_m());
        if (facing != Direction.UP) {
            return vec.func_186678_a((Boolean)context.state.func_177229_b((Property)FunnelBlock.EXTRACTING) != false ? 0.15 : 0.65);
        }
        return vec.func_186678_a(0.65);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        if (((Boolean)context.state.func_177229_b((Property)FunnelBlock.EXTRACTING)).booleanValue()) {
            this.extract(context, pos);
        } else {
            this.succ(context, pos);
        }
    }

    private void extract(MovementContext context, BlockPos pos) {
        ItemStack extract;
        World world = context.world;
        Vector3d entityPos = context.position;
        if (context.state.func_177229_b((Property)FunnelBlock.FACING) != Direction.DOWN) {
            entityPos = entityPos.func_72441_c(0.0, -0.5, 0.0);
        }
        if (!world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b()) {
            return;
        }
        if (!world.func_217357_a(ItemEntity.class, new AxisAlignedBB(new BlockPos(entityPos))).isEmpty()) {
            return;
        }
        ItemStack filter = this.getFilter(context);
        int filterAmount = context.tileData.func_74762_e("FilterAmount");
        if (filterAmount <= 0) {
            int n = filterAmount = this.hasFilter ? (Integer)AllConfigs.SERVER.logistics.defaultExtractionLimit.get() : 1;
        }
        if ((extract = ItemHelper.extract((IItemHandler)context.contraption.inventory, s -> FilterItem.test(world, s, filter), ItemHelper.ExtractionCountMode.UPTO, filterAmount, false)).func_190926_b()) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        ItemEntity entity = new ItemEntity(world, entityPos.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c, extract);
        entity.func_213317_d(Vector3d.field_186680_a);
        entity.func_174867_a(5);
        world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.0625f, 0.1f);
        world.func_217376_c((Entity)entity);
    }

    private void succ(MovementContext context, BlockPos pos) {
        World world = context.world;
        List items = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(pos));
        ItemStack filter = this.getFilter(context);
        for (ItemEntity item : items) {
            ItemStack remainder;
            if (!item.func_70089_S()) continue;
            ItemStack toInsert = item.func_92059_d();
            if (!filter.func_190926_b() && !FilterItem.test(context.world, toInsert, filter) || (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)context.contraption.inventory, (ItemStack)toInsert, (boolean)false)).func_190916_E() == toInsert.func_190916_E()) continue;
            if (remainder.func_190926_b()) {
                item.func_92058_a(ItemStack.field_190927_a);
                item.func_70106_y();
                continue;
            }
            item.func_92058_a(remainder);
        }
    }

    private ItemStack getFilter(MovementContext context) {
        return this.hasFilter ? ItemStack.func_199557_a((CompoundNBT)context.tileData.func_74775_l("Filter")) : ItemStack.field_190927_a;
    }
}

