/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelItem;
import com.simibubi.create.foundation.data.SpecialBlockStateGen;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.providers.RegistrateItemModelProvider;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class FunnelGenerator
extends SpecialBlockStateGen {
    private String type;
    private ResourceLocation particleTexture;
    private boolean hasFilter;

    public FunnelGenerator(String type, boolean hasFilter) {
        this.type = type;
        this.hasFilter = hasFilter;
        this.particleTexture = Create.asResource("block/" + type + "_casing");
    }

    @Override
    protected int getXRotation(BlockState state) {
        return state.func_177229_b((Property)FunnelBlock.FACING) == Direction.DOWN ? 180 : 0;
    }

    @Override
    protected int getYRotation(BlockState state) {
        return this.horizontalAngle((Direction)state.func_177229_b((Property)FunnelBlock.FACING)) + 180;
    }

    @Override
    public <T extends Block> ModelFile getModel(DataGenContext<Block, T> c, RegistrateBlockstateProvider p, BlockState s) {
        String powered = (Boolean)s.func_177229_b((Property)FunnelBlock.POWERED) != false ? "_powered" : "";
        String closed = (Boolean)s.func_177229_b((Property)FunnelBlock.POWERED) != false ? "_closed" : "_open";
        String extracting = (Boolean)s.func_177229_b((Property)FunnelBlock.EXTRACTING) != false ? "_push" : "_pull";
        Direction facing = (Direction)s.func_177229_b((Property)FunnelBlock.FACING);
        boolean horizontal = facing.func_176740_k().func_176722_c();
        String parent = horizontal ? "horizontal" : (this.hasFilter ? "vertical" : "vertical_filterless");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + this.type + "_funnel_" + parent + extracting + powered, p.modLoc("block/funnel/block_" + parent))).texture("particle", this.particleTexture)).texture("7", p.modLoc("block/" + this.type + "_funnel_plating"))).texture("5", p.modLoc("block/" + this.type + "_funnel_tall" + powered))).texture("2_2", p.modLoc("block/" + this.type + "_funnel" + extracting))).texture("3", p.modLoc("block/" + this.type + "_funnel_back"));
        if (horizontal) {
            return model.texture("6", p.modLoc("block/" + this.type + "_funnel" + powered));
        }
        return ((BlockModelBuilder)((BlockModelBuilder)model.texture("8", this.particleTexture)).texture("9", p.modLoc("block/" + this.type + "_funnel_slope"))).texture("10", p.modLoc("block/funnel" + closed));
    }

    public static NonNullBiConsumer<DataGenContext<Item, FunnelItem>, RegistrateItemModelProvider> itemModel(String type) {
        ResourceLocation particleTexture = Create.asResource("block/" + type + "_casing");
        return (c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent("item/" + type + "_funnel", p.modLoc("block/funnel/item"))).texture("particle", particleTexture)).texture("7", p.modLoc("block/" + type + "_funnel_plating"))).texture("2", p.modLoc("block/" + type + "_funnel_neutral"))).texture("6", p.modLoc("block/" + type + "_funnel"))).texture("5", p.modLoc("block/" + type + "_funnel_tall"))).texture("3", p.modLoc("block/" + type + "_funnel_back"));
    }
}

