/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ProcessingRecipeSerializer<T extends ProcessingRecipe<?>>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory;

    public ProcessingRecipeSerializer(ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory) {
        this.factory = factory;
    }

    protected void writeToJson(JsonObject json, T recipe) {
        HeatCondition requiredHeat;
        JsonArray jsonIngredients = new JsonArray();
        JsonArray jsonOutputs = new JsonArray();
        ((ProcessingRecipe)recipe).func_192400_c().forEach(i -> jsonIngredients.add(i.func_200304_c()));
        ((ProcessingRecipe)recipe).getFluidIngredients().forEach(i -> jsonIngredients.add((JsonElement)i.serialize()));
        ((ProcessingRecipe)recipe).getRollableResults().forEach(o -> jsonOutputs.add(o.serialize()));
        ((ProcessingRecipe)recipe).getFluidResults().forEach(o -> jsonOutputs.add(FluidHelper.serializeFluidStack(o)));
        json.add("ingredients", (JsonElement)jsonIngredients);
        json.add("results", (JsonElement)jsonOutputs);
        int processingDuration = ((ProcessingRecipe)recipe).getProcessingDuration();
        if (processingDuration > 0) {
            json.addProperty("processingTime", (Number)processingDuration);
        }
        if ((requiredHeat = ((ProcessingRecipe)recipe).getRequiredHeat()) != HeatCondition.NONE) {
            json.addProperty("heatRequirement", requiredHeat.serialize());
        }
        ((ProcessingRecipe)recipe).writeAdditional(json);
    }

    protected T readFromJson(ResourceLocation recipeId, JsonObject json) {
        ProcessingRecipeBuilder<T> builder = new ProcessingRecipeBuilder<T>(this.factory, recipeId);
        NonNullList ingredients = NonNullList.func_191196_a();
        NonNullList fluidIngredients = NonNullList.func_191196_a();
        NonNullList results = NonNullList.func_191196_a();
        NonNullList fluidResults = NonNullList.func_191196_a();
        for (JsonElement je : JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            if (FluidIngredient.isFluidIngredient(je)) {
                fluidIngredients.add((Object)FluidIngredient.deserialize(je));
                continue;
            }
            ingredients.add((Object)Ingredient.func_199802_a((JsonElement)je));
        }
        for (JsonElement je : JSONUtils.func_151214_t((JsonObject)json, (String)"results")) {
            JsonObject jsonObject = je.getAsJsonObject();
            if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"fluid")) {
                fluidResults.add((Object)FluidHelper.deserializeFluidStack(jsonObject));
                continue;
            }
            results.add((Object)ProcessingOutput.deserialize(je));
        }
        builder.withItemIngredients((NonNullList<Ingredient>)ingredients).withItemOutputs((NonNullList<ProcessingOutput>)results).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withFluidOutputs((NonNullList<FluidStack>)fluidResults);
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"processingTime")) {
            builder.duration(JSONUtils.func_151203_m((JsonObject)json, (String)"processingTime"));
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"heatRequirement")) {
            builder.requiresHeat(HeatCondition.deserialize(JSONUtils.func_151200_h((JsonObject)json, (String)"heatRequirement")));
        }
        T recipe = builder.build();
        ((ProcessingRecipe)recipe).readAdditional(json);
        return recipe;
    }

    protected void writeToBuffer(PacketBuffer buffer, T recipe) {
        NonNullList<Ingredient> ingredients = ((ProcessingRecipe)recipe).func_192400_c();
        NonNullList<FluidIngredient> fluidIngredients = ((ProcessingRecipe)recipe).getFluidIngredients();
        NonNullList<ProcessingOutput> outputs = ((ProcessingRecipe)recipe).getRollableResults();
        NonNullList<FluidStack> fluidOutputs = ((ProcessingRecipe)recipe).getFluidResults();
        buffer.func_150787_b(ingredients.size());
        ingredients.forEach(i -> i.func_199564_a(buffer));
        buffer.func_150787_b(fluidIngredients.size());
        fluidIngredients.forEach(i -> i.write(buffer));
        buffer.func_150787_b(outputs.size());
        outputs.forEach(o -> o.write(buffer));
        buffer.func_150787_b(fluidOutputs.size());
        fluidOutputs.forEach(o -> o.writeToPacket(buffer));
        buffer.func_150787_b(((ProcessingRecipe)recipe).getProcessingDuration());
        buffer.func_150787_b(((ProcessingRecipe)recipe).getRequiredHeat().ordinal());
        ((ProcessingRecipe)recipe).writeAdditional(buffer);
    }

    protected T readFromBuffer(ResourceLocation recipeId, PacketBuffer buffer) {
        int i;
        NonNullList ingredients = NonNullList.func_191196_a();
        NonNullList fluidIngredients = NonNullList.func_191196_a();
        NonNullList results = NonNullList.func_191196_a();
        NonNullList fluidResults = NonNullList.func_191196_a();
        int size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            ingredients.add((Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            fluidIngredients.add((Object)FluidIngredient.read(buffer));
        }
        size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            results.add((Object)ProcessingOutput.read(buffer));
        }
        size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            fluidResults.add((Object)FluidStack.readFromPacket((PacketBuffer)buffer));
        }
        T recipe = new ProcessingRecipeBuilder<T>(this.factory, recipeId).withItemIngredients((NonNullList<Ingredient>)ingredients).withItemOutputs((NonNullList<ProcessingOutput>)results).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withFluidOutputs((NonNullList<FluidStack>)fluidResults).duration(buffer.func_150792_a()).requiresHeat(HeatCondition.values()[buffer.func_150792_a()]).build();
        ((ProcessingRecipe)recipe).readAdditional(buffer);
        return recipe;
    }

    public final void write(JsonObject json, T recipe) {
        this.writeToJson(json, recipe);
    }

    public final T fromJson(ResourceLocation id, JsonObject json) {
        return this.readFromJson(id, json);
    }

    public final void toNetwork(PacketBuffer buffer, T recipe) {
        this.writeToBuffer(buffer, recipe);
    }

    public final T fromNetwork(ResourceLocation id, PacketBuffer buffer) {
        return this.readFromBuffer(id, buffer);
    }

    public ProcessingRecipeBuilder.ProcessingRecipeFactory<T> getFactory() {
        return this.factory;
    }
}

