/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.mixer.MechanicalMixerTileEntity;
import com.simibubi.create.content.contraptions.fluids.FluidFX;
import com.simibubi.create.content.contraptions.fluids.particle.FluidParticleData;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.processing.BasinBlock;
import com.simibubi.create.content.contraptions.processing.BasinInventory;
import com.simibubi.create.content.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class BasinTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    private boolean areFluidsMoving;
    LerpedFloat ingredientRotationSpeed;
    LerpedFloat ingredientRotation;
    public BasinInventory inputInventory = new BasinInventory(9, this);
    public SmartFluidTankBehaviour inputTank;
    protected SmartInventory outputInventory;
    protected SmartFluidTankBehaviour outputTank;
    private FilteringBehaviour filtering;
    private boolean contentsChanged;
    private Couple<SmartInventory> invs;
    private Couple<SmartFluidTankBehaviour> tanks;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    protected LazyOptional<IFluidHandler> fluidCapability;
    List<Direction> disabledSpoutputs;
    Direction preferredSpoutput;
    protected List<ItemStack> spoutputBuffer;
    protected List<FluidStack> spoutputFluidBuffer;
    public static final int OUTPUT_ANIMATION_TIME = 10;
    List<IntAttached<ItemStack>> visualizedOutputItems;
    List<IntAttached<FluidStack>> visualizedOutputFluids;

    public BasinTileEntity(TileEntityType<? extends BasinTileEntity> type) {
        super(type);
        this.inputInventory.whenContentsChanged($ -> {
            this.contentsChanged = true;
        });
        this.outputInventory = new BasinInventory(9, this).forbidInsertion().withMaxStackSize(64);
        this.areFluidsMoving = false;
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory}));
        this.contentsChanged = true;
        this.ingredientRotation = LerpedFloat.angular().startWithValue(0.0);
        this.ingredientRotationSpeed = LerpedFloat.linear().startWithValue(0.0);
        this.invs = Couple.create(this.inputInventory, this.outputInventory);
        this.tanks = Couple.create(this.inputTank, this.outputTank);
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
        this.disabledSpoutputs = new ArrayList<Direction>();
        this.preferredSpoutput = null;
        this.spoutputBuffer = new ArrayList<ItemStack>();
        this.spoutputFluidBuffer = new ArrayList<FluidStack>();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
        this.filtering = new FilteringBehaviour(this, new BasinValueBox()).moveText(new Vector3d(2.0, -8.0, 0.0)).withCallback(newFilter -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add(this.filtering);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add(this.inputTank);
        behaviours.add(this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional<? extends IFluidHandler> inputCap = this.inputTank.getCapability();
            LazyOptional<? extends IFluidHandler> outputCap = this.outputTank.getCapability();
            return new CombinedTankWrapper((IFluidHandler)inputCap.orElse(null), (IFluidHandler)outputCap.orElse(null));
        });
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.func_74775_l("InputItems"));
        this.outputInventory.deserializeNBT(compound.func_74775_l("OutputItems"));
        this.preferredSpoutput = null;
        if (compound.func_74764_b("PreferredSpoutput")) {
            this.preferredSpoutput = NBTHelper.readEnum(compound, "PreferredSpoutput", Direction.class);
        }
        this.disabledSpoutputs.clear();
        ListNBT disabledList = compound.func_150295_c("DisabledSpoutput", 8);
        disabledList.forEach(d -> this.disabledSpoutputs.add(Direction.valueOf((String)((StringNBT)d).func_150285_a_())));
        this.spoutputBuffer = NBTHelper.readItemList(compound.func_150295_c("Overflow", 10));
        this.spoutputFluidBuffer = NBTHelper.readCompoundList(compound.func_150295_c("FluidOverflow", 10), FluidStack::loadFluidStackFromNBT);
        if (!clientPacket) {
            return;
        }
        NBTHelper.iterateCompoundList(compound.func_150295_c("VisualizedItems", 10), c -> this.visualizedOutputItems.add(IntAttached.with(10, ItemStack.func_199557_a((CompoundNBT)c))));
        NBTHelper.iterateCompoundList(compound.func_150295_c("VisualizedFluids", 10), c -> this.visualizedOutputFluids.add(IntAttached.with(10, FluidStack.loadFluidStackFromNBT((CompoundNBT)c))));
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_218657_a("InputItems", (INBT)this.inputInventory.serializeNBT());
        compound.func_218657_a("OutputItems", (INBT)this.outputInventory.serializeNBT());
        if (this.preferredSpoutput != null) {
            NBTHelper.writeEnum(compound, "PreferredSpoutput", this.preferredSpoutput);
        }
        ListNBT disabledList = new ListNBT();
        this.disabledSpoutputs.forEach(d -> disabledList.add((Object)StringNBT.func_229705_a_((String)d.name())));
        compound.func_218657_a("DisabledSpoutput", (INBT)disabledList);
        compound.func_218657_a("Overflow", (INBT)NBTHelper.writeItemList(this.spoutputBuffer));
        compound.func_218657_a("FluidOverflow", (INBT)NBTHelper.writeCompoundList(this.spoutputFluidBuffer, fs -> fs.writeToNBT(new CompoundNBT())));
        if (!clientPacket) {
            return;
        }
        compound.func_218657_a("VisualizedItems", (INBT)NBTHelper.writeCompoundList(this.visualizedOutputItems, ia -> ((ItemStack)ia.getValue()).serializeNBT()));
        compound.func_218657_a("VisualizedFluids", (INBT)NBTHelper.writeCompoundList(this.visualizedOutputFluids, ia -> ((FluidStack)ia.getValue()).writeToNBT(new CompoundNBT())));
        this.visualizedOutputItems.clear();
        this.visualizedOutputFluids.clear();
    }

    public void onEmptied() {
        this.getOperator().ifPresent(te -> {
            te.basinRemoved = true;
        });
    }

    @Override
    public void func_145843_s() {
        this.onEmptied();
        this.itemCapability.invalidate();
        this.fluidCapability.invalidate();
        super.func_145843_s();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void notifyUpdate() {
        super.notifyUpdate();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.updateSpoutput();
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(2));
        if (!(tileEntity instanceof MechanicalMixerTileEntity)) {
            this.setAreFluidsMoving(false);
            return;
        }
        MechanicalMixerTileEntity mixer = (MechanicalMixerTileEntity)tileEntity;
        this.setAreFluidsMoving(mixer.running && mixer.runningTicks <= 20);
    }

    public void onWrenched(Direction face) {
        BlockState blockState = this.func_195044_w();
        Direction currentFacing = (Direction)blockState.func_177229_b((Property)BasinBlock.FACING);
        this.disabledSpoutputs.remove(face);
        if (currentFacing == face) {
            if (this.preferredSpoutput == face) {
                this.preferredSpoutput = null;
            }
            this.disabledSpoutputs.add(face);
        } else {
            this.preferredSpoutput = face;
        }
        this.updateSpoutput();
    }

    private void updateSpoutput() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState blockState = this.func_195044_w();
        Direction currentFacing = (Direction)blockState.func_177229_b((Property)BasinBlock.FACING);
        if (currentFacing != Direction.DOWN) {
            this.notifyChangeOfContents();
        }
        Direction newFacing = Direction.DOWN;
        for (Direction test : Iterate.horizontalDirections) {
            boolean canOutputTo = BasinBlock.canOutputTo((IBlockReader)this.field_145850_b, this.field_174879_c, test);
            if (!canOutputTo || this.disabledSpoutputs.contains(test)) continue;
            newFacing = test;
        }
        if (this.preferredSpoutput != null && BasinBlock.canOutputTo((IBlockReader)this.field_145850_b, this.field_174879_c, this.preferredSpoutput) && this.preferredSpoutput != Direction.UP) {
            newFacing = this.preferredSpoutput;
        }
        if (newFacing != currentFacing) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)blockState.func_206870_a((Property)BasinBlock.FACING, (Comparable)newFacing));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.createFluidParticles();
            this.tickVisualizedOutputs();
            this.ingredientRotationSpeed.tickChaser();
            this.ingredientRotation.setValue(this.ingredientRotation.getValue() + this.ingredientRotationSpeed.getValue());
        }
        if (!(this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty() || this.field_145850_b.field_72995_K)) {
            this.tryClearingSpoutputOverflow();
        }
        if (!this.contentsChanged) {
            return;
        }
        this.contentsChanged = false;
        this.getOperator().ifPresent(te -> te.basinChecker.scheduleUpdate());
        for (Direction offset : Iterate.horizontalDirections) {
            TileEntity te2;
            BlockPos toUpdate = this.field_174879_c.func_177984_a().func_177972_a(offset);
            BlockState stateToUpdate = this.field_145850_b.func_180495_p(toUpdate);
            if (!(stateToUpdate.func_177230_c() instanceof BasinBlock) || stateToUpdate.func_177229_b((Property)BasinBlock.FACING) != offset.func_176734_d() || !((te2 = this.field_145850_b.func_175625_s(toUpdate)) instanceof BasinTileEntity)) continue;
            ((BasinTileEntity)te2).contentsChanged = true;
        }
    }

    private void tryClearingSpoutputOverflow() {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof BasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.func_177229_b((Property)BasinBlock.FACING);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b().func_177972_a(direction));
        FilteringBehaviour filter = null;
        CapManipulationBehaviourBase inserter = null;
        if (te != null) {
            filter = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, te.func_174877_v(), FilteringBehaviour.TYPE);
            inserter = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, te.func_174877_v(), InvManipulationBehaviour.TYPE);
        }
        IItemHandler targetInv = te == null ? null : (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
        IFluidHandler targetTank = te == null ? null : (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()).orElse(null);
        boolean update = false;
        Iterator<ItemStack> iterator = this.spoutputBuffer.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            if (direction == Direction.DOWN) {
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)itemStack);
                iterator.remove();
                update = true;
                continue;
            }
            if (targetInv == null) break;
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack, (boolean)true).func_190926_b() || filter != null && !filter.test(itemStack)) continue;
            update = true;
            ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.func_77946_l(), (boolean)false);
            iterator.remove();
            this.visualizedOutputItems.add(IntAttached.withZero(itemStack));
        }
        iterator = this.spoutputFluidBuffer.iterator();
        block1: while (iterator.hasNext()) {
            FluidStack fluidStack = (FluidStack)iterator.next();
            if (direction == Direction.DOWN) {
                iterator.remove();
                update = true;
                continue;
            }
            if (targetTank == null) break;
            for (boolean simulate : Iterate.trueAndFalse) {
                IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
                int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
                if (fill != fluidStack.getAmount()) continue block1;
                if (simulate) continue;
                update = true;
                iterator.remove();
                this.visualizedOutputFluids.add(IntAttached.withZero(fluidStack));
            }
        }
        if (update) {
            this.notifyChangeOfContents();
            this.sendData();
        }
    }

    public float getTotalFluidUnits(float partialTicks) {
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                totalUnits += units;
                ++renderedFluids;
            }
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    private Optional<BasinOperatingTileEntity> getOperator() {
        if (this.field_145850_b == null) {
            return Optional.empty();
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(2));
        if (te instanceof BasinOperatingTileEntity) {
            return Optional.of((BasinOperatingTileEntity)te);
        }
        return Optional.empty();
    }

    public FilteringBehaviour getFilter() {
        return this.filtering;
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public SmartInventory getInputInventory() {
        return this.inputInventory;
    }

    public SmartInventory getOutputInventory() {
        return this.outputInventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 256.0;
    }

    public boolean canContinueProcessing() {
        return this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty();
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        this.outputInventory.allowInsertion();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, simulate);
        this.outputInventory.forbidInsertion();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof BasinBlock)) {
            return false;
        }
        Direction direction = (Direction)blockState.func_177229_b((Property)BasinBlock.FACING);
        if (direction != Direction.DOWN) {
            boolean externalTankNotPresent;
            InvManipulationBehaviour inserter;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b().func_177972_a(direction));
            InvManipulationBehaviour invManipulationBehaviour = inserter = te == null ? null : TileEntityBehaviour.get((IBlockReader)this.field_145850_b, te.func_174877_v(), InvManipulationBehaviour.TYPE);
            IItemHandler targetInv = te == null ? null : (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
            IFluidHandler targetTank = te == null ? null : (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()).orElse(null);
            boolean bl = externalTankNotPresent = targetTank == null;
            if (!outputItems.isEmpty() && targetInv == null) {
                return false;
            }
            if (!outputFluids.isEmpty() && externalTankNotPresent) {
                targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
                if (targetTank == null) {
                    return false;
                }
                if (!this.acceptFluidOutputsIntoBasin(outputFluids, simulate, targetTank)) {
                    return false;
                }
            }
            if (simulate) {
                return true;
            }
            for (ItemStack itemStack : outputItems) {
                if (itemStack.hasContainerItem() && itemStack.getContainerItem().func_77969_a(itemStack)) continue;
                this.spoutputBuffer.add(itemStack.func_77946_l());
            }
            if (!externalTankNotPresent) {
                for (FluidStack fluidStack : outputFluids) {
                    this.spoutputFluidBuffer.add(fluidStack.copy());
                }
            }
            return true;
        }
        SmartInventory targetInv = this.outputInventory;
        IFluidHandler targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        if (!this.acceptItemOutputsIntoBasin(outputItems, simulate, (IItemHandler)targetInv)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoBasin(outputFluids, simulate, targetTank);
    }

    private boolean acceptFluidOutputsIntoBasin(List<FluidStack> outputFluids, boolean simulate, IFluidHandler targetTank) {
        for (FluidStack fluidStack : outputFluids) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
            if (fill == fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptItemOutputsIntoBasin(List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (itemStack.hasContainerItem() && itemStack.getContainerItem().func_77969_a(itemStack) || ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.func_77946_l(), (boolean)simulate).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void readOnlyItems(CompoundNBT compound) {
        this.inputInventory.deserializeNBT(compound.func_74775_l("InputItems"));
        this.outputInventory.deserializeNBT(compound.func_74775_l("OutputItems"));
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevelOf(BlockState state) {
        if (state.func_235901_b_(BlazeBurnerBlock.HEAT_LEVEL)) {
            return (BlazeBurnerBlock.HeatLevel)((Object)state.func_177229_b(BlazeBurnerBlock.HEAT_LEVEL));
        }
        return AllTags.AllBlockTags.FAN_HEATERS.matches(state) ? BlazeBurnerBlock.HeatLevel.SMOULDERING : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public Couple<SmartFluidTankBehaviour> getTanks() {
        return this.tanks;
    }

    public Couple<SmartInventory> getInvs() {
        return this.invs;
    }

    private void tickVisualizedOutputs() {
        this.visualizedOutputFluids.forEach(IntAttached::decrement);
        this.visualizedOutputItems.forEach(IntAttached::decrement);
        this.visualizedOutputFluids.removeIf(IntAttached::isOrBelowZero);
        this.visualizedOutputItems.removeIf(IntAttached::isOrBelowZero);
    }

    private void createFluidParticles() {
        Random r = this.field_145850_b.field_73012_v;
        if (!this.visualizedOutputFluids.isEmpty()) {
            this.createOutputFluidParticles(r);
        }
        if (!this.areFluidsMoving && r.nextFloat() > 0.125f) {
            return;
        }
        int segments = 0;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                ++segments;
            }
        }
        if (segments < 2) {
            return;
        }
        float totalUnits = this.getTotalFluidUnits(0.0f);
        if (totalUnits == 0.0f) {
            return;
        }
        float fluidLevel = MathHelper.func_76131_a((float)(totalUnits / 2000.0f), (float)0.0f, (float)1.0f);
        float rim = 0.125f;
        float space = 0.75f;
        float surface = (float)this.field_174879_c.func_177956_o() + rim + space * fluidLevel + 0.03125f;
        if (this.areFluidsMoving) {
            this.createMovingFluidParticles(surface, segments);
            return;
        }
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                float x = (float)this.field_174879_c.func_177958_n() + rim + space * r.nextFloat();
                float z = (float)this.field_174879_c.func_177952_p() + rim + space * r.nextFloat();
                this.field_145850_b.func_195589_b((IParticleData)new FluidParticleData(AllParticleTypes.BASIN_FLUID.get(), tankSegment.getRenderedFluid()), (double)x, (double)surface, (double)z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void createOutputFluidParticles(Random r) {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof BasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.func_177229_b((Property)BasinBlock.FACING);
        if (direction == Direction.DOWN) {
            return;
        }
        Vector3d directionVec = Vector3d.func_237491_b_((Vector3i)direction.func_176730_m());
        Vector3d outVec = VecHelper.getCenterOf((Vector3i)this.field_174879_c).func_178787_e(directionVec.func_186678_a(0.65).func_178786_a(0.0, 0.25, 0.0));
        Vector3d outMotion = directionVec.func_186678_a(0.0625).func_72441_c(0.0, -0.0625, 0.0);
        for (int i = 0; i < 2; ++i) {
            this.visualizedOutputFluids.forEach(ia -> {
                FluidStack fluidStack = (FluidStack)ia.getValue();
                IParticleData fluidParticle = FluidFX.getFluidParticle(fluidStack);
                Vector3d m = VecHelper.offsetRandomly(outMotion, r, 0.0625f);
                this.field_145850_b.func_195589_b(fluidParticle, outVec.field_72450_a, outVec.field_72448_b, outVec.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
            });
        }
    }

    private void createMovingFluidParticles(float surface, int segments) {
        Vector3d pointer = new Vector3d(1.0, 0.0, 0.0).func_186678_a(0.0625);
        float interval = 360.0f / (float)segments;
        Vector3d centerOf = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        float intervalOffset = AnimationTickHolder.getTicks() * 18 % 360;
        int currentSegment = 0;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                float angle = interval * (float)(1 + currentSegment) + intervalOffset;
                Vector3d vec = centerOf.func_178787_e(VecHelper.rotate(pointer, angle, Direction.Axis.Y));
                this.field_145850_b.func_195589_b((IParticleData)new FluidParticleData(AllParticleTypes.BASIN_FLUID.get(), tankSegment.getRenderedFluid()), vec.func_82615_a(), (double)surface, vec.func_82616_c(), 1.0, 0.0, 0.0);
                ++currentSegment;
            }
        }
    }

    public boolean areFluidsMoving() {
        return this.areFluidsMoving;
    }

    public boolean setAreFluidsMoving(boolean areFluidsMoving) {
        this.areFluidsMoving = areFluidsMoving;
        this.ingredientRotationSpeed.chase(areFluidsMoving ? 20.0 : 0.0, 0.1f, LerpedFloat.Chaser.EXP);
        return areFluidsMoving;
    }

    @Override
    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }

    class BasinValueBox
    extends ValueBoxTransform.Sided {
        BasinValueBox() {
        }

        @Override
        protected Vector3d getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 12.0, 15.75);
        }

        @Override
        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.func_176740_k().func_176722_c();
        }
    }
}

