/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.pipes.SmartFluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.StraightPipeTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraftforge.fluids.FluidStack;

public class SmartFluidPipeTileEntity
extends SmartTileEntity {
    private FilteringBehaviour filter;

    public SmartFluidPipeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new SmartPipeBehaviour(this));
        this.filter = new FilteringBehaviour(this, new SmartPipeFilterSlot()).forFluids().withCallback(this::onFilterChanged);
        behaviours.add(this.filter);
    }

    private void onFilterChanged(ItemStack newFilter) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        FluidPropagator.propagateChangedPipe((IWorld)this.field_145850_b, this.field_174879_c, this.func_195044_w());
    }

    class SmartPipeFilterSlot
    extends ValueBoxTransform {
        SmartPipeFilterSlot() {
        }

        @Override
        protected Vector3d getLocalOffset(BlockState state) {
            float y;
            AttachFace face = (AttachFace)state.func_177229_b((Property)SmartFluidPipeBlock.field_196366_M);
            float f = face == AttachFace.CEILING ? 0.3f : (y = face == AttachFace.WALL ? 11.3f : 15.3f);
            float z = face == AttachFace.CEILING ? 4.6f : (face == AttachFace.WALL ? 0.6f : 4.6f);
            return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, y, z), this.angleY(state), Direction.Axis.Y);
        }

        @Override
        protected void rotate(BlockState state, MatrixStack ms) {
            AttachFace face = (AttachFace)state.func_177229_b((Property)SmartFluidPipeBlock.field_196366_M);
            MatrixTransformStack.of((MatrixStack)ms).rotateY((double)this.angleY(state)).rotateX(face == AttachFace.CEILING ? -45.0 : 45.0);
        }

        protected float angleY(BlockState state) {
            AttachFace face = (AttachFace)state.func_177229_b((Property)SmartFluidPipeBlock.field_196366_M);
            float horizontalAngle = AngleHelper.horizontalAngle((Direction)state.func_177229_b((Property)SmartFluidPipeBlock.field_185512_D));
            if (face == AttachFace.WALL) {
                horizontalAngle += 180.0f;
            }
            return horizontalAngle;
        }
    }

    class SmartPipeBehaviour
    extends StraightPipeTileEntity.StraightPipeFluidTransportBehaviour {
        public SmartPipeBehaviour(SmartTileEntity te) {
            super(te);
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, BlockState state, Direction direction) {
            if (fluid.isEmpty() || SmartFluidPipeTileEntity.this.filter != null && SmartFluidPipeTileEntity.this.filter.test(fluid)) {
                return super.canPullFluidFrom(fluid, state, direction);
            }
            return false;
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return state.func_177230_c() instanceof SmartFluidPipeBlock && SmartFluidPipeBlock.getPipeAxis(state) == direction.func_176740_k();
        }
    }
}

