/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.fluids.actors.ItemDrainTileEntity;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.tileEntity.renderer.SmartTileEntityRenderer;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fluids.FluidStack;

public class ItemDrainRenderer
extends SmartTileEntityRenderer<ItemDrainTileEntity> {
    public ItemDrainRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(ItemDrainTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        this.renderFluid(te, partialTicks, ms, buffer, light);
        this.renderItem(te, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItem(ItemDrainTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        boolean alongX;
        TransportedItemStack transported = te.heldItem;
        if (transported == null) {
            return;
        }
        MatrixTransformStack msr = MatrixTransformStack.of((MatrixStack)ms);
        Vector3d itemPosition = VecHelper.getCenterOf((Vector3i)te.func_174877_v());
        Direction insertedFrom = transported.insertedFrom;
        if (!insertedFrom.func_176740_k().func_176722_c()) {
            return;
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.9375, 0.5);
        msr.nudge(0);
        float offset = MathHelper.func_219799_g((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition);
        float sideOffset = MathHelper.func_219799_g((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
        Vector3d offsetVec = Vector3d.func_237491_b_((Vector3i)insertedFrom.func_176734_d().func_176730_m()).func_186678_a((double)(0.5f - offset));
        ms.func_227861_a_(offsetVec.field_72450_a, offsetVec.field_72448_b, offsetVec.field_72449_c);
        boolean bl = alongX = insertedFrom.func_176746_e().func_176740_k() == Direction.Axis.X;
        if (!alongX) {
            sideOffset *= -1.0f;
        }
        ms.func_227861_a_(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)sideOffset);
        ItemStack itemStack = transported.stack;
        Random r = new Random(0L);
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        int count = MathHelper.func_151239_c((int)itemStack.func_190916_E()) / 2;
        boolean renderUpright = BeltHelper.isItemUpright(itemStack);
        boolean blockItem = itemRenderer.func_184393_a(itemStack, null, null).func_177556_c();
        if (renderUpright) {
            ms.func_227861_a_(0.0, 0.09375, 0.0);
        }
        int positive = insertedFrom.func_176743_c().func_179524_a();
        float verticalAngle = (float)positive * offset * 360.0f;
        if (insertedFrom.func_176740_k() != Direction.Axis.X) {
            msr.rotateX((double)verticalAngle);
        }
        if (insertedFrom.func_176740_k() != Direction.Axis.Z) {
            msr.rotateZ((double)(-verticalAngle));
        }
        if (renderUpright) {
            Entity renderViewEntity = Minecraft.func_71410_x().field_175622_Z;
            if (renderViewEntity != null) {
                Vector3d positionVec = renderViewEntity.func_213303_ch();
                Vector3d vectorForOffset = itemPosition.func_178787_e(offsetVec);
                Vector3d diff = vectorForOffset.func_178788_d(positionVec);
                if (insertedFrom.func_176740_k() != Direction.Axis.X) {
                    diff = VecHelper.rotate(diff, verticalAngle, Direction.Axis.X);
                }
                if (insertedFrom.func_176740_k() != Direction.Axis.Z) {
                    diff = VecHelper.rotate(diff, -verticalAngle, Direction.Axis.Z);
                }
                float yRot = (float)MathHelper.func_181159_b((double)diff.field_72449_c, (double)(-diff.field_72450_a));
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)((double)yRot - 1.5707963267948966)));
            }
            ms.func_227861_a_(0.0, 0.0, -0.0625);
        }
        for (int i = 0; i <= count; ++i) {
            ms.func_227860_a_();
            if (blockItem) {
                ms.func_227861_a_((double)(r.nextFloat() * 0.0625f * (float)i), 0.0, (double)(r.nextFloat() * 0.0625f * (float)i));
            }
            ms.func_227862_a_(0.5f, 0.5f, 0.5f);
            if (!blockItem && !renderUpright) {
                msr.rotateX(90.0);
            }
            itemRenderer.func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
            ms.func_227865_b_();
            if (!renderUpright) {
                if (!blockItem) {
                    msr.rotateY(10.0);
                }
                ms.func_227861_a_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                continue;
            }
            ms.func_227861_a_(0.0, 0.0, -0.0625);
        }
        ms.func_227865_b_();
    }

    protected void renderFluid(ItemDrainTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light) {
        ItemStack heldItemStack;
        SmartFluidTankBehaviour tank = te.internalTank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f) {
            float yMin = 0.3125f;
            float min = 0.125f;
            float max = min + 0.75f;
            float yOffset = 0.4375f * level;
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, (double)yOffset, 0.0);
            FluidRenderer.renderTiledFluidBB(fluidStack, min, yMin - yOffset, min, max, yMin, max, buffer, ms, light, false);
            ms.func_227865_b_();
        }
        if ((heldItemStack = te.getHeldItemStack()).func_190926_b()) {
            return;
        }
        FluidStack fluidStack2 = EmptyingByBasin.emptyItem(te.func_145831_w(), heldItemStack, true).getFirst();
        if (fluidStack2.isEmpty()) {
            if (fluidStack.isEmpty()) {
                return;
            }
            fluidStack2 = fluidStack;
        }
        int processingTicks = te.processingTicks;
        float processingPT = (float)te.processingTicks - partialTicks;
        float processingProgress = 1.0f - (processingPT - 5.0f) / 10.0f;
        processingProgress = MathHelper.func_76131_a((float)processingProgress, (float)0.0f, (float)1.0f);
        float radius = 0.0f;
        if (processingTicks != -1) {
            radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
            AxisAlignedBB bb = new AxisAlignedBB(0.5, 1.0, 0.5, 0.5, 0.25, 0.5).func_186662_g((double)(radius / 32.0f));
            FluidRenderer.renderTiledFluidBB(fluidStack2, (float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f, buffer, ms, light, true);
        }
    }
}

