/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.fluids.actors.FillingRecipe;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class FillingBySpout {
    static RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public static boolean canItemBeFilled(World world, ItemStack stack) {
        wrapper.func_70299_a(0, stack);
        Optional<FillingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(world, wrapper, AllRecipeTypes.FILLING.getType(), FillingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return true;
        }
        if (AllRecipeTypes.FILLING.find(wrapper, world).isPresent()) {
            return true;
        }
        return GenericItemFilling.canItemBeFilled(world, stack);
    }

    public static int getRequiredAmountForItem(World world, ItemStack stack, FluidStack availableFluid) {
        FluidIngredient requiredFluid;
        wrapper.func_70299_a(0, stack);
        Optional<FillingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(world, wrapper, AllRecipeTypes.FILLING.getType(), FillingRecipe.class);
        if (assemblyRecipe.isPresent() && (requiredFluid = assemblyRecipe.get().getRequiredFluid()).test(availableFluid)) {
            return requiredFluid.getRequiredAmount();
        }
        for (IRecipe recipe : world.func_199532_z().func_215370_b(AllRecipeTypes.FILLING.getType(), (IInventory)wrapper, world)) {
            FillingRecipe fillingRecipe = (FillingRecipe)recipe;
            FluidIngredient requiredFluid2 = fillingRecipe.getRequiredFluid();
            if (!requiredFluid2.test(availableFluid)) continue;
            return requiredFluid2.getRequiredAmount();
        }
        return GenericItemFilling.getRequiredAmountForItem(world, stack, availableFluid);
    }

    public static ItemStack fillItem(World world, int requiredAmount, ItemStack stack, FluidStack availableFluid) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);
        wrapper.func_70299_a(0, stack);
        FillingRecipe fillingRecipe = SequencedAssemblyRecipe.getRecipe(world, wrapper, AllRecipeTypes.FILLING.getType(), FillingRecipe.class).filter(fr -> fr.getRequiredFluid().test(toFill)).orElseGet(() -> {
            for (IRecipe recipe : world.func_199532_z().func_215370_b(AllRecipeTypes.FILLING.getType(), (IInventory)wrapper, world)) {
                FillingRecipe fr = (FillingRecipe)recipe;
                FluidIngredient requiredFluid = fr.getRequiredFluid();
                if (!requiredFluid.test(toFill)) continue;
                return fr;
            }
            return null;
        });
        if (fillingRecipe != null) {
            List<ItemStack> results = fillingRecipe.rollResults();
            availableFluid.shrink(requiredAmount);
            stack.func_190918_g(1);
            return results.isEmpty() ? ItemStack.field_190927_a : results.get(0);
        }
        return GenericItemFilling.fillItem(world, requiredAmount, stack, availableFluid);
    }
}

