/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.mounted;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssembleRailType;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerTileEntity;
import com.simibubi.create.content.contraptions.components.tracks.ControllerRailBlock;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CartAssemblerBlock
extends AbstractRailBlock
implements ITE<CartAssemblerTileEntity>,
IWrenchable,
ISpecialBlockItemRequirement {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty BACKWARDS = BooleanProperty.func_177716_a((String)"backwards");
    public static final Property<RailShape> RAIL_SHAPE = EnumProperty.func_177706_a((String)"shape", RailShape.class, (Enum[])new RailShape[]{RailShape.EAST_WEST, RailShape.NORTH_SOUTH});
    public static final Property<CartAssembleRailType> RAIL_TYPE = EnumProperty.func_177709_a((String)"rail_type", CartAssembleRailType.class);

    public CartAssemblerBlock(AbstractBlock.Properties properties) {
        super(true, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BACKWARDS, (Comparable)Boolean.valueOf(false))).func_206870_a(RAIL_TYPE, (Comparable)((Object)CartAssembleRailType.POWERED_RAIL)));
    }

    public static BlockState createAnchor(BlockState state) {
        Direction.Axis axis = state.func_177229_b(RAIL_SHAPE) == RailShape.NORTH_SOUTH ? Direction.Axis.Z : Direction.Axis.X;
        return (BlockState)AllBlocks.MINECART_ANCHOR.getDefaultState().func_206870_a((Property)BlockStateProperties.field_208199_z, (Comparable)axis);
    }

    private static Item getRailItem(BlockState state) {
        return ((CartAssembleRailType)((Object)state.func_177229_b(RAIL_TYPE))).getItem();
    }

    public static BlockState getRailBlock(BlockState state) {
        AbstractRailBlock railBlock = (AbstractRailBlock)((CartAssembleRailType)((Object)state.func_177229_b(RAIL_TYPE))).getBlock();
        BlockState railState = (BlockState)railBlock.func_176223_P().func_206870_a(railBlock.func_176560_l(), state.func_177229_b(RAIL_SHAPE));
        if (railState.func_235901_b_((Property)ControllerRailBlock.BACKWARDS)) {
            railState = (BlockState)railState.func_206870_a((Property)ControllerRailBlock.BACKWARDS, state.func_177229_b((Property)BACKWARDS));
        }
        return railState;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{RAIL_SHAPE, POWERED, RAIL_TYPE, BACKWARDS});
        super.func_206840_a(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CART_ASSEMBLER.create();
    }

    public boolean canMakeSlopes(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return false;
    }

    public void onMinecartPass(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, AbstractMinecartEntity cart) {
        if (!CartAssemblerBlock.canAssembleTo(cart)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        this.withTileEntityDo((IBlockReader)world, pos, te -> te.assembleNextTick(cart));
    }

    public static CartAssemblerAction getActionForCart(BlockState state, AbstractMinecartEntity cart) {
        CartAssembleRailType type = (CartAssembleRailType)((Object)state.func_177229_b(RAIL_TYPE));
        boolean powered = (Boolean)state.func_177229_b((Property)POWERED);
        switch (type) {
            case ACTIVATOR_RAIL: {
                return powered ? CartAssemblerAction.DISASSEMBLE : CartAssemblerAction.PASS;
            }
            case CONTROLLER_RAIL: {
                return powered ? CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL : CartAssemblerAction.DISASSEMBLE_BRAKE;
            }
            case DETECTOR_RAIL: {
                return cart.func_184188_bt().isEmpty() ? CartAssemblerAction.ASSEMBLE_ACCELERATE : CartAssemblerAction.DISASSEMBLE;
            }
            case POWERED_RAIL: {
                return powered ? CartAssemblerAction.ASSEMBLE_ACCELERATE : CartAssemblerAction.DISASSEMBLE_BRAKE;
            }
            case REGULAR: {
                return powered ? CartAssemblerAction.ASSEMBLE : CartAssemblerAction.DISASSEMBLE;
            }
        }
        return CartAssemblerAction.PASS;
    }

    public static boolean canAssembleTo(AbstractMinecartEntity cart) {
        return cart.canBeRidden() || cart instanceof FurnaceMinecartEntity || cart instanceof ChestMinecartEntity;
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult blockRayTraceResult) {
        ItemStack itemStack = player.func_184586_b(hand);
        Item previousItem = CartAssemblerBlock.getRailItem(state);
        Item heldItem = itemStack.func_77973_b();
        if (heldItem != previousItem) {
            CartAssembleRailType newType = null;
            for (CartAssembleRailType type : CartAssembleRailType.values()) {
                if (heldItem != type.getItem()) continue;
                newType = type;
            }
            if (newType == null) {
                return ActionResultType.PASS;
            }
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, 1.0f);
            world.func_175656_a(pos, (BlockState)state.func_206870_a(RAIL_TYPE, (Comparable)((Object)newType)));
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
                player.field_71071_by.func_191975_a(world, new ItemStack((IItemProvider)previousItem));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.func_177229_b((Property)POWERED);
        if (previouslyPowered != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERED), 2);
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    @Nonnull
    public Property<RailShape> func_176560_l() {
        return RAIL_SHAPE;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return AllShapes.CART_ASSEMBLER.get(this.getRailAxis(state));
    }

    protected Direction.Axis getRailAxis(BlockState state) {
        return state.func_177229_b(RAIL_SHAPE) == RailShape.NORTH_SOUTH ? Direction.Axis.Z : Direction.Axis.X;
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, ISelectionContext context) {
        Entity entity = context.getEntity();
        if (entity instanceof AbstractMinecartEntity) {
            return VoxelShapes.func_197880_a();
        }
        if (entity instanceof PlayerEntity) {
            return AllShapes.CART_ASSEMBLER_PLAYER_COLLISION.get(this.getRailAxis(state));
        }
        return VoxelShapes.func_197868_b();
    }

    @Nonnull
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    @Override
    public Class<CartAssemblerTileEntity> getTileEntityClass() {
        return CartAssemblerTileEntity.class;
    }

    public boolean func_196260_a(@Nonnull BlockState state, @Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        return false;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, TileEntity te) {
        ArrayList<ItemStack> reuiredItems = new ArrayList<ItemStack>();
        reuiredItems.add(new ItemStack((IItemProvider)CartAssemblerBlock.getRailItem(state)));
        reuiredItems.add(new ItemStack((IItemProvider)this.func_199767_j()));
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, reuiredItems);
    }

    @Nonnull
    public List<ItemStack> func_220076_a(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        drops.addAll(CartAssemblerBlock.getRailBlock(state).func_215693_a(builder));
        return drops;
    }

    public List<ItemStack> getDropsNoRail(BlockState state, ServerWorld world, BlockPos pos, @Nullable TileEntity p_220077_3_, @Nullable Entity p_220077_4_, ItemStack p_220077_5_) {
        return super.func_220076_a(state, new LootContext.Builder(world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237491_b_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)p_220077_5_).func_216021_b(LootParameters.field_216281_a, (Object)p_220077_4_).func_216021_b(LootParameters.field_216288_h, (Object)p_220077_3_));
    }

    @Override
    public ActionResultType onSneakWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player != null && !player.func_184812_l_()) {
            this.getDropsNoRail(state, (ServerWorld)world, pos, world.func_175625_s(pos), (Entity)player, context.func_195996_i()).forEach(itemStack -> player.field_71071_by.func_191975_a(world, itemStack));
        }
        if (world instanceof ServerWorld) {
            state.func_215706_a((ServerWorld)world, pos, ItemStack.field_190927_a);
        }
        world.func_175656_a(pos, CartAssemblerBlock.getRailBlock(state));
        return ActionResultType.SUCCESS;
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType type) {
        return false;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockPos pos = context.func_195995_a();
        world.func_180501_a(pos, this.func_185499_a(state, Rotation.CLOCKWISE_90), 3);
        world.func_195593_d(pos.func_177977_b(), (Block)this);
        return ActionResultType.SUCCESS;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return state;
        }
        BlockState base = ((BlockState)((BlockState)AllBlocks.CONTROLLER_RAIL.getDefaultState().func_206870_a(ControllerRailBlock.SHAPE, state.func_177229_b(RAIL_SHAPE))).func_206870_a((Property)ControllerRailBlock.BACKWARDS, state.func_177229_b((Property)BACKWARDS))).func_185907_a(rotation);
        return (BlockState)((BlockState)state.func_206870_a(RAIL_SHAPE, base.func_177229_b(ControllerRailBlock.SHAPE))).func_206870_a((Property)BACKWARDS, base.func_177229_b((Property)ControllerRailBlock.BACKWARDS));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        BlockState base = ((BlockState)((BlockState)AllBlocks.CONTROLLER_RAIL.getDefaultState().func_206870_a(ControllerRailBlock.SHAPE, state.func_177229_b(RAIL_SHAPE))).func_206870_a((Property)ControllerRailBlock.BACKWARDS, state.func_177229_b((Property)BACKWARDS))).func_185902_a(mirror);
        return (BlockState)state.func_206870_a((Property)BACKWARDS, base.func_177229_b((Property)ControllerRailBlock.BACKWARDS));
    }

    public static Direction getHorizontalDirection(BlockState blockState) {
        if (!(blockState.func_177230_c() instanceof CartAssemblerBlock)) {
            return Direction.SOUTH;
        }
        Direction pointingTo = CartAssemblerBlock.getPointingTowards(blockState);
        return (Boolean)blockState.func_177229_b((Property)BACKWARDS) != false ? pointingTo.func_176734_d() : pointingTo;
    }

    private static Direction getPointingTowards(BlockState state) {
        switch ((RailShape)state.func_177229_b(RAIL_SHAPE)) {
            case EAST_WEST: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public static class MinecartAnchorBlock
    extends Block {
        public MinecartAnchorBlock(AbstractBlock.Properties p_i48440_1_) {
            super(p_i48440_1_);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            builder.func_206894_a(new Property[]{BlockStateProperties.field_208199_z});
            super.func_206840_a(builder);
        }

        @Nonnull
        public VoxelShape func_220053_a(@Nonnull BlockState p_220053_1_, @Nonnull IBlockReader p_220053_2_, @Nonnull BlockPos p_220053_3_, @Nonnull ISelectionContext p_220053_4_) {
            return VoxelShapes.func_197880_a();
        }
    }

    public static enum CartAssemblerAction {
        ASSEMBLE,
        DISASSEMBLE,
        ASSEMBLE_ACCELERATE,
        DISASSEMBLE_BRAKE,
        ASSEMBLE_ACCELERATE_DIRECTIONAL,
        PASS;


        public boolean shouldAssemble() {
            return this == ASSEMBLE || this == ASSEMBLE_ACCELERATE || this == ASSEMBLE_ACCELERATE_DIRECTIONAL;
        }

        public boolean shouldDisassemble() {
            return this == DISASSEMBLE || this == DISASSEMBLE_BRAKE;
        }
    }
}

