/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.actors.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.PloughBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BubbleColumnBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PloughMovementBehaviour
extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176734_d());
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        World world = context.world;
        if (world.field_72995_K) {
            return;
        }
        BlockPos below = pos.func_177977_b();
        if (!world.func_195588_v(below)) {
            return;
        }
        Vector3d vec = VecHelper.getCenterOf((Vector3i)pos);
        PloughBlock.PloughFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        BlockRayTraceResult ray = world.func_217299_a(new RayTraceContext(vec, vec.func_72441_c(0.0, -1.0, 0.0), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (ray.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        ItemUseContext ctx = new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, ray);
        new ItemStack((IItemProvider)Items.field_151012_L).func_196084_a(ctx);
    }

    @Override
    public Vector3d getActiveAreaOffset(MovementContext context) {
        return Vector3d.func_237491_b_((Vector3i)((Direction)context.state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176730_m()).func_186678_a(0.45);
    }

    @Override
    protected boolean throwsEntities() {
        return true;
    }

    @Override
    public boolean canBreak(World world, BlockPos breakingPos, BlockState state) {
        if (world.func_180495_p(breakingPos.func_177977_b()).func_177230_c() instanceof FarmlandBlock) {
            return false;
        }
        if (state.func_177230_c() instanceof FlowingFluidBlock) {
            return false;
        }
        if (state.func_177230_c() instanceof BubbleColumnBlock) {
            return false;
        }
        return state.func_196952_d((IBlockReader)world, breakingPos).func_197766_b();
    }

    @Override
    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        super.onBlockBroken(context, pos, brokenState);
        if (brokenState.func_177230_c() == Blocks.field_150433_aE && context.world instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)context.world;
            brokenState.func_215693_a(new LootContext.Builder(world).func_216015_a(LootParameters.field_216287_g, (Object)brokenState).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216281_a, (Object)this.getPlayer(context)).func_216015_a(LootParameters.field_216289_i, (Object)new ItemStack((IItemProvider)Items.field_151037_a))).forEach(s -> this.dropItem(context, (ItemStack)s));
        }
    }

    @Override
    public void stopMoving(MovementContext context) {
        super.stopMoving(context);
        if (context.temporaryData instanceof PloughBlock.PloughFakePlayer) {
            ((PloughBlock.PloughFakePlayer)((Object)context.temporaryData)).func_70106_y();
        }
    }

    private PloughBlock.PloughFakePlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof PloughBlock.PloughFakePlayer) && context.world != null) {
            PloughBlock.PloughFakePlayer player = new PloughBlock.PloughFakePlayer((ServerWorld)context.world);
            player.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151012_L));
            context.temporaryData = player;
        }
        return (PloughBlock.PloughFakePlayer)((Object)context.temporaryData);
    }
}

