/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.actors.HarvesterBlock;
import com.simibubi.create.content.contraptions.components.actors.HarvesterTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HarvesterRenderer
extends SafeTileEntityRenderer<HarvesterTileEntity> {
    public HarvesterRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(HarvesterTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        BlockState blockState = te.func_195044_w();
        SuperByteBuffer superBuffer = PartialBufferer.get(AllBlockPartials.HARVESTER_BLADE, blockState);
        HarvesterRenderer.transform(te.func_145831_w(), (Direction)blockState.func_177229_b((Property)HarvesterBlock.field_185512_D), superBuffer, te.getAnimatedSpeed());
        superBuffer.light(light).renderInto(ms, buffer.getBuffer(RenderType.func_228641_d_()));
    }

    public static void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, IRenderTypeBuffer buffers) {
        float speed;
        BlockState blockState = context.state;
        Direction facing = (Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        SuperByteBuffer superBuffer = PartialBufferer.get(AllBlockPartials.HARVESTER_BLADE, blockState);
        float f = speed = !VecHelper.isVecPointingTowards(context.relativeMotion, facing.func_176734_d()) ? context.getAnimationSpeed() : 0.0f;
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        superBuffer.transform(matrices.getModel());
        HarvesterRenderer.transform(context.world, facing, superBuffer, speed);
        superBuffer.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), buffers.getBuffer(RenderType.func_228641_d_()));
    }

    public static void transform(World world, Direction facing, SuperByteBuffer superBuffer, float speed) {
        float originOffset = 0.0625f;
        Vector3d rotOffset = new Vector3d(0.0, (double)(-2.0f * originOffset), (double)originOffset).func_178787_e(VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a));
        float time = AnimationTickHolder.getRenderTime((IWorld)world) / 20.0f;
        float angle = time * speed % 360.0f;
        superBuffer.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing))).translate(rotOffset.field_72450_a, rotOffset.field_72448_b, rotOffset.field_72449_c).rotate(Direction.WEST, AngleHelper.rad(angle)).translate(-rotOffset.field_72450_a, -rotOffset.field_72448_b, -rotOffset.field_72449_c);
    }
}

