/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SequencedAssemblyCategory
extends CreateRecipeCategory<SequencedAssemblyRecipe> {
    Map<ResourceLocation, SequencedAssemblySubCategory> subCategories = new HashMap<ResourceLocation, SequencedAssemblySubCategory>();
    final String[] romans = new String[]{"I", "II", "III", "IV", "V", "VI", "-"};

    public SequencedAssemblyCategory() {
        super(SequencedAssemblyCategory.itemIcon((IItemProvider)AllItems.PRECISION_MECHANISM.get()), new EmptyBackground(180, 115));
    }

    public Class<? extends SequencedAssemblyRecipe> getRecipeClass() {
        return SequencedAssemblyRecipe.class;
    }

    public void setIngredients(SequencedAssemblyRecipe recipe, IIngredients ingredients) {
        List<Ingredient> assemblyIngredients = this.getAllItemIngredients(recipe);
        List<FluidIngredient> assemblyFluidIngredients = this.getAllFluidIngredients(recipe);
        ingredients.setInputIngredients(assemblyIngredients);
        if (!assemblyFluidIngredients.isEmpty()) {
            ingredients.setInputLists(VanillaTypes.FLUID, assemblyFluidIngredients.stream().map(FluidIngredient::getMatchingFluidStacks).collect(Collectors.toList()));
        }
        ingredients.setOutputs(VanillaTypes.ITEM, (List)ImmutableList.of((Object)recipe.func_77571_b(), (Object)recipe.getTransitionalItem()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, SequencedAssemblyRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        int xOffset = recipe.getOutputChance() == 1.0f ? 0 : -7;
        itemStacks.init(0, true, 26 + xOffset, 90);
        itemStacks.set(0, Arrays.asList(recipe.getIngredient().func_193365_a()));
        ItemStack result = recipe.func_77571_b();
        itemStacks.init(1, false, 131 + xOffset, 90);
        itemStacks.set(1, result);
        int width = 0;
        int margin = 3;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
        }
        int x = (width -= margin) / -2 + this.getBackground().getWidth() / 2;
        int index = 2;
        int fluidIndex = 0;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            SequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
            index += subCategory.addItemIngredients(sequencedRecipe, itemStacks, x, index);
            fluidIndex += subCategory.addFluidIngredients(sequencedRecipe, fluidStacks, x, fluidIndex);
            x += subCategory.getWidth() + margin;
        }
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex != 1) {
                return;
            }
            float chance = recipe.getOutputChance();
            if (chance != 1.0f) {
                tooltip.add(1, Lang.translate("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).func_240699_a_(TextFormatting.GOLD));
            }
        });
    }

    private SequencedAssemblySubCategory getSubCategory(SequencedRecipe<?> sequencedRecipe) {
        return this.subCategories.computeIfAbsent(sequencedRecipe.getRecipe().func_199559_b().getRegistryName(), rl -> sequencedRecipe.getAsAssemblyRecipe().getJEISubCategory().get().get());
    }

    public void draw(SequencedAssemblyRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 15.0, 0.0);
        boolean singleOutput = recipe.getOutputChance() == 1.0f;
        int xOffset = singleOutput ? 0 : -7;
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 26 + xOffset, 75);
        (singleOutput ? AllGuiTextures.JEI_SLOT : AllGuiTextures.JEI_CHANCE_SLOT).draw(matrixStack, 131 + xOffset, 75);
        AllGuiTextures.JEI_LONG_ARROW.draw(matrixStack, 52 + xOffset, 79);
        if (!singleOutput) {
            AllGuiTextures.JEI_CHANCE_SLOT.draw(matrixStack, 150 + xOffset, 75);
            IFormattableTextComponent component = new StringTextComponent("?").func_240699_a_(TextFormatting.BOLD);
            font.func_243246_a(matrixStack, (ITextComponent)component, (float)(font.func_238414_a_((ITextProperties)component) / -2 + 8 + 150 + xOffset), 80.0f, 0xEFEFEF);
        }
        if (recipe.getLoops() > 1) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(15.0, 9.0, 0.0);
            RenderSystem.color4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
            AllIcons.I_REFRESH.draw(matrixStack, 50 + xOffset, 75);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            StringTextComponent repeat = new StringTextComponent("x" + recipe.getLoops());
            font.func_243248_b(matrixStack, (ITextComponent)repeat, (float)(66 + xOffset), 80.0f, 0x888888);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        int width = 0;
        int margin = 3;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
        }
        matrixStack.func_227861_a_((double)((width -= margin) / -2 + this.getBackground().getWidth() / 2), 0.0, 0.0);
        matrixStack.func_227860_a_();
        List<SequencedRecipe<?>> sequence = recipe.getSequence();
        for (int i = 0; i < sequence.size(); ++i) {
            SequencedRecipe<?> sequencedRecipe = sequence.get(i);
            SequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
            int subWidth = subCategory.getWidth();
            StringTextComponent component = new StringTextComponent("" + this.romans[Math.min(i, 6)]);
            font.func_243248_b(matrixStack, (ITextComponent)component, (float)(font.func_238414_a_((ITextProperties)component) / -2 + subWidth / 2), 2.0f, 0x888888);
            subCategory.draw(sequencedRecipe, matrixStack, mouseX, mouseY, i);
            matrixStack.func_227861_a_((double)(subWidth + margin), 0.0, 0.0);
        }
        matrixStack.func_227865_b_();
    }

    public List<ITextComponent> getTooltipStrings(SequencedAssemblyRecipe recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        TranslationTextComponent junk = Lang.translate("recipe.assembly.junk", new Object[0]);
        boolean singleOutput = recipe.getOutputChance() == 1.0f;
        boolean willRepeat = recipe.getLoops() > 1;
        int xOffset = -7;
        int minX = 150 + xOffset;
        int maxX = minX + 18;
        int minY = 90;
        int maxY = minY + 18;
        if (!singleOutput && mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
            float chance = recipe.getOutputChance();
            tooltip.add((ITextComponent)junk);
            tooltip.add((ITextComponent)Lang.translate("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf(100 - (int)(chance * 100.0f))).func_240699_a_(TextFormatting.GOLD));
            return tooltip;
        }
        minX = 55 + xOffset;
        maxX = minX + 65;
        minY = 92;
        maxY = minY + 24;
        if (willRepeat && mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
            tooltip.add((ITextComponent)Lang.translate("recipe.assembly.repeat", recipe.getLoops()));
            return tooltip;
        }
        if (mouseY > 5.0 && mouseY < 84.0) {
            int width = 0;
            int margin = 3;
            for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
                width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
            }
            xOffset = (width -= margin) / 2 + this.getBackground().getWidth() / -2;
            double relativeX = mouseX + (double)xOffset;
            List<SequencedRecipe<?>> sequence = recipe.getSequence();
            for (int i = 0; i < sequence.size(); ++i) {
                SequencedRecipe<?> sequencedRecipe = sequence.get(i);
                SequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
                if (relativeX >= 0.0 && relativeX < (double)subCategory.getWidth()) {
                    tooltip.add((ITextComponent)Lang.translate("recipe.assembly.step", i + 1));
                    tooltip.add((ITextComponent)sequencedRecipe.getAsAssemblyRecipe().getDescriptionForAssembly().func_230531_f_().func_240699_a_(TextFormatting.DARK_GREEN));
                    return tooltip;
                }
                relativeX -= (double)(subCategory.getWidth() + margin);
            }
        }
        return tooltip;
    }

    private List<FluidIngredient> getAllFluidIngredients(SequencedAssemblyRecipe recipe) {
        ArrayList<FluidIngredient> assemblyFluidIngredients = new ArrayList<FluidIngredient>();
        recipe.addAdditionalFluidIngredients(assemblyFluidIngredients);
        return assemblyFluidIngredients;
    }

    private List<Ingredient> getAllItemIngredients(SequencedAssemblyRecipe recipe) {
        ArrayList<Ingredient> assemblyIngredients = new ArrayList<Ingredient>();
        assemblyIngredients.add(recipe.getIngredient());
        assemblyIngredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{recipe.getTransitionalItem()}));
        recipe.addAdditionalIngredientsAndMachines(assemblyIngredients);
        return assemblyIngredients;
    }
}

