/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.item;

import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.registry.ModConfigs;
import jackyy.exchangers.util.Reference;
import jackyy.gunpowderlib.capability.FEItemStackCapability;
import jackyy.gunpowderlib.capability.FEStorageCapability;
import jackyy.gunpowderlib.capability.IFEContainer;
import jackyy.gunpowderlib.helper.EnergyHelper;
import jackyy.gunpowderlib.helper.KeyHelper;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;

public class ItemExchangerBasePowered
extends ItemExchangerBase
implements IFEContainer {
    public ItemExchangerBasePowered(Item.Properties props) {
        super(props.func_200917_a(1));
    }

    public int receiveEnergy(ItemStack container, int energy, boolean simulate) {
        return EnergyHelper.receiveEnergy((ItemStack)container, (int)energy, (boolean)simulate);
    }

    public int extractEnergy(ItemStack container, int energy, boolean simulate) {
        return EnergyHelper.extractEnergy((ItemStack)container, (int)energy, (boolean)simulate);
    }

    public int getEnergyStored(ItemStack container) {
        return EnergyHelper.getEnergyStored((ItemStack)container);
    }

    public int getMaxEnergyStored(ItemStack container) {
        if (((Boolean)ModConfigs.CONFIG.holdingEnchantment.get()).booleanValue() && ModList.get().isLoaded("cofh_core")) {
            int enchant = EnchantmentHelper.func_77506_a((Enchantment)Reference.holdingEnchant, (ItemStack)container);
            return this.getMaxEnergy() + this.getMaxEnergy() * enchant / 2;
        }
        return this.getMaxEnergy();
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (KeyHelper.isShiftKeyDown()) {
            tooltip.add((ITextComponent)StringHelper.formatNumber((long)this.getEnergyStored(stack)).func_240702_b_(" / ").func_230529_a_((ITextComponent)StringHelper.formatNumber((long)this.getMaxEnergyStored(stack))).func_240702_b_(" " + (String)ModConfigs.CONFIG.energyUnit.get()));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && this.checkLoaded()) {
            ItemStack empty = new ItemStack((IItemProvider)this);
            ExchangerHandler.setDefaultTagCompound(empty);
            items.add((Object)empty);
            ItemStack full = new ItemStack((IItemProvider)this);
            ExchangerHandler.setDefaultTagCompound(full);
            EnergyHelper.setDefaultEnergyTag((ItemStack)full, (int)this.getMaxEnergyStored(full));
            items.add((Object)full);
        }
    }

    @Override
    public boolean isPowered() {
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new FEItemStackCapability((IEnergyStorage)new FEStorageCapability((IFEContainer)this, stack));
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_185306_r || enchantment == Enchantments.field_185307_s || enchantment == Reference.holdingEnchant;
    }
}

