/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.gunpowderlib.helper.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemHandler {
    public static boolean consumeItemInInventory(Item item, PlayerInventory playerInv, PlayerEntity player) {
        if (player.func_184812_l_() || ExchangerHandler.getExIsCreative(player.func_184614_ca())) {
            return true;
        }
        int i = ItemHandler.findItem(item, (IInventory)playerInv);
        if (i < 0) {
            NonNullList<IItemHandler> containers = ItemHandler.findItemContainers((IInventory)playerInv);
            if (containers.isEmpty()) {
                return false;
            }
            for (IItemHandler container : containers) {
                i = ItemHandler.findItemInContainer(item, container);
                if (i < 0) continue;
                container.extractItem(i, 1, false);
                return true;
            }
        } else {
            playerInv.func_70298_a(i, 1);
            return true;
        }
        return false;
    }

    public static int findItem(Item item, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static int findItemInContainer(Item item, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (inv.extractItem(i, 1, true).func_190926_b() || stack.func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static NonNullList<IItemHandler> findItemContainers(IInventory inv) {
        NonNullList containers = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            IItemHandler container = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
            if (stack.func_190926_b() || container == null || stack.getCapability(CapabilityEnergy.ENERGY, null).isPresent()) continue;
            containers.add((Object)container);
        }
        return containers;
    }

    public static ItemStack getSilkTouchDrop(BlockState state) {
        Block block = state.func_177230_c();
        Item item = block.func_199767_j();
        return new ItemStack((IItemProvider)item, 1);
    }

    public static void giveItem(World world, PlayerEntity player, ItemStack oldStack) {
        ItemEntity entityItem = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), oldStack);
        if (NBTHelper.getTag((ItemStack)player.func_184614_ca()).func_74767_n("forceDropItems")) {
            world.func_217376_c((Entity)entityItem);
        } else if (!player.field_71071_by.func_70441_a(oldStack)) {
            world.func_217376_c((Entity)entityItem);
        }
    }
}

