/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import jackyy.exchangers.client.RenderTypeExt;
import jackyy.exchangers.client.gui.ExchangersGuiScreen;
import jackyy.exchangers.client.keybind.Keys;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.handler.network.NetworkHandler;
import jackyy.exchangers.handler.network.packet.PacketSwitchMode;
import jackyy.exchangers.handler.network.packet.PacketSwitchRange;
import jackyy.exchangers.handler.network.packet.PacketToggleDirectionalPlacement;
import jackyy.exchangers.handler.network.packet.PacketToggleForceDropItems;
import jackyy.exchangers.handler.network.packet.PacketToggleFuzzyPlacement;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.item.special.ItemCreativeExchanger;
import jackyy.gunpowderlib.helper.NBTHelper;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventsHandler {
    private static Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE || !(mc.func_175606_aa() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)mc.func_175606_aa();
        if (player == null || !mc.func_195544_aj() || !Minecraft.func_71382_s() || player.func_184614_ca().func_190926_b() || !(player.func_184614_ca().func_77973_b() instanceof ItemExchangerBase)) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (NBTHelper.hasTag((ItemStack)stack)) {
            MainWindow mainWindow = mc.func_228018_at_();
            int w = mainWindow.func_198107_o();
            int h = mainWindow.func_198087_p();
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            RenderSystem.disableDepthTest();
            String exchangeRange = ExchangerHandler.rangeList[NBTHelper.getTag((ItemStack)stack).func_74762_e("range")];
            float scale = exchangeRange.length() > 2 ? 1.0f : 1.0f;
            float swidth = (float)ClientEventsHandler.mc.field_71466_p.func_78256_a(exchangeRange) * scale;
            matrixStack.func_227861_a_((double)w / 2.0 - 2.0 - (double)swidth, (double)h / 2.0 - 4.0, 0.0);
            matrixStack.func_227862_a_(scale, scale, 1.0f);
            ClientEventsHandler.mc.field_71466_p.func_238405_a_(event.getMatrixStack(), exchangeRange, 0.0f, 0.0f, 0xFFFFFF);
            matrixStack.func_227865_b_();
            RenderSystem.enableDepthTest();
        }
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        ClientPlayerEntity player = ClientEventsHandler.mc.field_71439_g;
        if (player != null && mouseOver instanceof BlockRayTraceResult) {
            World world = player.func_130014_f_();
            BlockRayTraceResult mouseOverBlock = (BlockRayTraceResult)mouseOver;
            BlockPos pos = mouseOverBlock.func_216350_a();
            BlockState state = world.func_180495_p(pos);
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemExchangerBase && stack.func_77978_p() != null && !state.isAir((IBlockReader)world, pos) && state.func_204520_s() == Fluids.field_204541_a.func_207188_f()) {
                BlockState exState = NBTUtil.func_190008_d((CompoundNBT)NBTHelper.getTag((ItemStack)stack).func_74775_l("blockstate"));
                float blockHardness = state.func_185887_b((IBlockReader)world, pos);
                if (exState == state) {
                    return;
                }
                Set<BlockPos> blocks = ExchangerHandler.findSuitableBlocks(stack, player.func_130014_f_(), (PlayerEntity)player, mouseOverBlock.func_216354_b(), pos, state);
                MatrixStack matrixStack = event.getMatrixStack();
                IRenderTypeBuffer.Impl bufferSource = mc.func_228019_au_().func_228487_b_();
                if (player.func_225608_bj_() && (world.func_175625_s(pos) != null && !ExchangerHandler.isWhitelisted(world, pos) || ExchangerHandler.isBlacklisted(world, pos) || !(stack.func_77973_b() instanceof ItemCreativeExchanger) && blockHardness < -0.1f)) {
                    this.renderExchangerRange(matrixStack, bufferSource, blocks, 1.0f, 0.1f, 0.1f, 1.0f);
                } else if (player.func_225608_bj_()) {
                    this.renderExchangerRange(matrixStack, bufferSource, blocks, 0.1f, 1.0f, 0.1f, 1.0f);
                } else {
                    this.renderExchangerRange(matrixStack, bufferSource, blocks, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }

    private void renderExchangerRange(MatrixStack matrixStack, IRenderTypeBuffer.Impl bufferSource, Set<BlockPos> blocks, float r, float g, float b, float a) {
        IVertexBuilder builder = bufferSource.getBuffer(RenderTypeExt.BLOCK_OUTLINES);
        matrixStack.func_227860_a_();
        Vector3d projectedView = ClientEventsHandler.mc.field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f posMatrix = matrixStack.func_227866_c_().func_227870_a_();
        for (BlockPos pos : blocks) {
            float x = pos.func_177958_n();
            float y = pos.func_177956_o();
            float z = pos.func_177952_p();
            builder.func_227888_a_(posMatrix, x, y, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y + 1.0f, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y + 1.0f, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y + 1.0f, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y + 1.0f, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y + 1.0f, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y + 1.0f, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y + 1.0f, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y + 1.0f, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y + 1.0f, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y + 1.0f, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y + 1.0f, z).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x + 1.0f, y, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_227888_a_(posMatrix, x, y + 1.0f, z + 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        bufferSource.func_228462_a_(RenderTypeExt.BLOCK_OUTLINES);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        ItemStack heldItem;
        ClientPlayerEntity player = ClientEventsHandler.mc.field_71439_g;
        if (player != null && !(heldItem = player.func_184614_ca()).func_190926_b() && heldItem.func_77973_b() instanceof ItemExchangerBase) {
            ExchangerHandler.setDefaultTagCompound(heldItem);
            if (Keys.OPEN_GUI_KEY.func_151468_f()) {
                mc.func_147108_a((Screen)new ExchangersGuiScreen());
            } else if (Keys.RANGE_SWITCH_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketSwitchRange());
            } else if (Keys.MODE_SWITCH_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketSwitchMode());
            } else if (Keys.FORCE_DROP_ITEMS_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketToggleForceDropItems());
            } else if (Keys.DIRECTIONAL_PLACEMENT_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketToggleDirectionalPlacement());
            } else if (Keys.FUZZY_PLACEMENT_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketToggleFuzzyPlacement());
            }
        }
    }
}

