/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import jackyy.exchangers.client.gui.ImageButtonExt;
import jackyy.exchangers.client.gui.ToggleButton;
import jackyy.exchangers.client.keybind.Keys;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.handler.mode.ModeHorizontalCol;
import jackyy.exchangers.handler.mode.ModePlane;
import jackyy.exchangers.handler.mode.ModeVerticalCol;
import jackyy.exchangers.handler.network.NetworkHandler;
import jackyy.exchangers.handler.network.packet.PacketDecreaseRange;
import jackyy.exchangers.handler.network.packet.PacketIncreaseRange;
import jackyy.exchangers.handler.network.packet.PacketSetFuzzyPlacementChance;
import jackyy.exchangers.handler.network.packet.PacketSwitchMode;
import jackyy.exchangers.handler.network.packet.PacketToggleDirectionalPlacement;
import jackyy.exchangers.handler.network.packet.PacketToggleForceDropItems;
import jackyy.exchangers.handler.network.packet.PacketToggleFuzzyPlacement;
import jackyy.exchangers.handler.network.packet.PacketToggleVoidItems;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.util.Reference;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ExchangersGuiScreen
extends Screen {
    private static Minecraft mc = Minecraft.func_71410_x();
    private final ResourceLocation GUI_IMAGE = new ResourceLocation("exchangers", "textures/gui/gui_exchanger.png");
    private static final int W = 180;
    private static final int H = 150;
    private String chance;
    private ImageButtonExt decreaseRangeButton;
    private ImageButtonExt increaseRangeButton;
    private ToggleButton modeSwitchButton;
    private ToggleButton forceDropItemsButton;
    private ToggleButton directionalPlacementButton;
    private ToggleButton fuzzyPlacementButton;
    private ToggleButton voidItemsButton;
    private TextFieldWidget fuzzyPlacementChanceField;

    public ExchangersGuiScreen() {
        super((ITextComponent)new TranslationTextComponent("screen.exchangers.exchanger_gui.title"));
        this.field_230708_k_ = 180;
        this.field_230709_l_ = 150;
    }

    public void func_231160_c_() {
        int relativeX = (this.field_230708_k_ - 180) / 2;
        int relativeY = (this.field_230709_l_ - 150) / 2;
        ItemStack stack = ExchangersGuiScreen.mc.field_71439_g.func_184614_ca();
        CompoundNBT tag = stack.func_77978_p();
        this.chance = Integer.toString(tag.func_74762_e("fuzzyPlacementChance"));
        this.decreaseRangeButton = new ImageButtonExt(relativeX + 54, relativeY + 31, 10, 15, 180, 0, 15, 30, this.GUI_IMAGE, button -> NetworkHandler.sendToServer(new PacketDecreaseRange()));
        this.increaseRangeButton = new ImageButtonExt(relativeX + 116, relativeY + 31, 10, 15, 190, 0, 15, 30, this.GUI_IMAGE, button -> NetworkHandler.sendToServer(new PacketIncreaseRange()));
        this.modeSwitchButton = new ToggleButton(relativeX + 20, relativeY + 66, 20, 20, (ITextComponent)new StringTextComponent("\u29c8"), button -> NetworkHandler.sendToServer(new PacketSwitchMode()));
        this.forceDropItemsButton = new ToggleButton(relativeX + 60, relativeY + 66, 20, 20, (ITextComponent)new StringTextComponent("\u2b0a"), button -> NetworkHandler.sendToServer(new PacketToggleForceDropItems()));
        this.directionalPlacementButton = new ToggleButton(relativeX + 100, relativeY + 66, 20, 20, (ITextComponent)new StringTextComponent("\u2927"), button -> NetworkHandler.sendToServer(new PacketToggleDirectionalPlacement()));
        this.fuzzyPlacementButton = new ToggleButton(relativeX + 52, relativeY + 106, 20, 20, (ITextComponent)new StringTextComponent("\u224b"), button -> NetworkHandler.sendToServer(new PacketToggleFuzzyPlacement()));
        this.voidItemsButton = new ToggleButton(relativeX + 140, relativeY + 66, 20, 20, (ITextComponent)new StringTextComponent("\u2a37"), button -> NetworkHandler.sendToServer(new PacketToggleVoidItems()));
        this.func_230480_a_((Widget)this.decreaseRangeButton);
        this.func_230480_a_((Widget)this.increaseRangeButton);
        this.func_230480_a_((Widget)this.modeSwitchButton);
        this.func_230480_a_((Widget)this.forceDropItemsButton);
        this.func_230480_a_((Widget)this.directionalPlacementButton);
        this.func_230480_a_((Widget)this.fuzzyPlacementButton);
        this.func_230480_a_((Widget)this.voidItemsButton);
        this.fuzzyPlacementChanceField = new TextFieldWidget(this.field_230712_o_, relativeX + 92, relativeY + 108, 26, 16, StringTextComponent.field_240750_d_);
        this.fuzzyPlacementChanceField.func_146203_f(3);
        this.fuzzyPlacementChanceField.func_146180_a(this.chance);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        FontRenderer fontRenderer = ExchangersGuiScreen.mc.field_71466_p;
        ItemStack stack = ExchangersGuiScreen.mc.field_71439_g.func_184614_ca();
        ItemExchangerBase exchanger = (ItemExchangerBase)stack.func_77973_b();
        CompoundNBT tag = stack.func_77978_p();
        this.func_230446_a_(matrixStack);
        int relativeX = (this.field_230708_k_ - 180) / 2;
        int relativeY = (this.field_230709_l_ - 150) / 2;
        mc.func_110434_K().func_110577_a(this.GUI_IMAGE);
        this.func_238474_b_(matrixStack, relativeX, relativeY, 0, 0, 180, 150);
        this.field_230707_j_.func_180450_b(stack, relativeX + 82, relativeY + 8);
        int range = tag.func_74762_e("range");
        String exchangeRange = ExchangerHandler.rangeList[range];
        fontRenderer.func_238405_a_(matrixStack, exchangeRange, (float)(relativeX + 90) - (float)fontRenderer.func_78256_a(exchangeRange) / 2.0f, (float)(relativeY + 34), -1);
        this.fuzzyPlacementChanceField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        fontRenderer.func_238405_a_(matrixStack, "%", (float)(relativeX + 121), (float)(relativeY + 112), -1);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.decreaseRangeButton.setButtonDisabled(range == 0);
        this.increaseRangeButton.setButtonDisabled(range == exchanger.getMaxRange());
        this.forceDropItemsButton.setButtonToggled(tag.func_74767_n("forceDropItems"));
        this.directionalPlacementButton.setButtonToggled(tag.func_74767_n("directionalPlacement"));
        this.fuzzyPlacementButton.setButtonToggled(tag.func_74767_n("fuzzyPlacement"));
        this.voidItemsButton.setButtonToggled(tag.func_74767_n("voidItems"));
        if (this.decreaseRangeButton.func_230449_g_()) {
            this.drawToolTip(matrixStack, Collections.singletonList(StringHelper.localize((String)"exchangers", (String)"tooltip.decrease_range_button", (Object[])new Object[0])), mouseX, mouseY);
        }
        if (this.increaseRangeButton.func_230449_g_()) {
            this.drawToolTip(matrixStack, Collections.singletonList(StringHelper.localize((String)"exchangers", (String)"tooltip.increase_range_button", (Object[])new Object[0])), mouseX, mouseY);
        }
        if (this.modeSwitchButton.func_230449_g_()) {
            int mode = tag.func_74762_e("mode");
            switch (mode) {
                case 0: {
                    this.drawToolTip(matrixStack, (List<ITextComponent>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.mode_switch_button", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModePlane.getDisplayName().func_240699_a_(TextFormatting.GREEN)})), mouseX, mouseY);
                    break;
                }
                case 1: {
                    this.drawToolTip(matrixStack, (List<ITextComponent>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.mode_switch_button", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModeHorizontalCol.getDisplayName().func_240699_a_(TextFormatting.GREEN)})), mouseX, mouseY);
                    break;
                }
                case 2: {
                    this.drawToolTip(matrixStack, (List<ITextComponent>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.mode_switch_button", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModeVerticalCol.getDisplayName().func_240699_a_(TextFormatting.GREEN)})), mouseX, mouseY);
                }
            }
        }
        if (this.forceDropItemsButton.func_230449_g_()) {
            this.drawToolTip(matrixStack, (List<ITextComponent>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.force_drop_items_button_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.force_drop_items_button_desc", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.state", (Object[])new Object[]{Reference.getStateString(tag.func_74767_n("forceDropItems"))})), mouseX, mouseY);
        }
        if (this.directionalPlacementButton.func_230449_g_()) {
            this.drawToolTip(matrixStack, (List<ITextComponent>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.directional_placement_button_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.directional_placement_button_desc", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.state", (Object[])new Object[]{Reference.getStateString(tag.func_74767_n("directionalPlacement"))})), mouseX, mouseY);
        }
        if (this.fuzzyPlacementButton.func_230449_g_()) {
            this.drawToolTip(matrixStack, (List<ITextComponent>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement_button_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement_button_desc", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.state", (Object[])new Object[]{Reference.getStateString(tag.func_74767_n("fuzzyPlacement"))})), mouseX, mouseY);
        }
        if (this.voidItemsButton.func_230449_g_()) {
            this.drawToolTip(matrixStack, (List<ITextComponent>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.void_items_button_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.void_items_button_desc", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.state", (Object[])new Object[]{Reference.getStateString(tag.func_74767_n("voidItems"))})), mouseX, mouseY);
        }
        if (this.fuzzyPlacementChanceField.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.drawToolTip(matrixStack, (List<ITextComponent>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement_chance_box_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement_chance_box_desc", (Object[])new Object[0])), mouseX, mouseY);
        }
    }

    private void drawToolTip(MatrixStack matrixStack, List<ITextComponent> tooltips, int x, int y) {
        GuiUtils.drawHoveringText((MatrixStack)matrixStack, tooltips, (int)x, (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)200, (FontRenderer)this.field_230712_o_);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.fuzzyPlacementChanceField.func_231044_a_(mouseX, mouseY, button);
        if (!this.fuzzyPlacementChanceField.func_230999_j_()) {
            if (!this.fuzzyPlacementChanceField.func_146179_b().isEmpty()) {
                this.parseFuzzyPlacementChance(this.fuzzyPlacementChanceField, 1, 100);
                return super.func_231044_a_(mouseX, mouseY, button);
            }
            this.fuzzyPlacementChanceField.func_146180_a(this.chance);
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (259 == keyCode || 261 == keyCode || 263 == keyCode || 262 == keyCode || 268 == keyCode || 269 == keyCode) {
            return this.fuzzyPlacementChanceField.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (this.fuzzyPlacementChanceField.func_230999_j_()) {
            if (!(256 != keyCode && 257 != keyCode && 335 != keyCode || this.fuzzyPlacementChanceField.func_146179_b().isEmpty())) {
                this.fuzzyPlacementChanceField.func_231049_c__(false);
                this.parseFuzzyPlacementChance(this.fuzzyPlacementChanceField, 1, 100);
                return true;
            }
        } else if (256 == keyCode || Keys.OPEN_GUI_KEY.getKey().func_197937_c() == keyCode || ExchangersGuiScreen.mc.field_71474_y.field_151445_Q.getKey().func_197937_c() == keyCode) {
            this.func_231175_as__();
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.fuzzyPlacementChanceField.func_230999_j_() && Character.isDigit(codePoint)) {
            this.fuzzyPlacementChanceField.func_231042_a_(codePoint, modifiers);
        }
        return super.func_231042_a_(codePoint, modifiers);
    }

    private void parseFuzzyPlacementChance(TextFieldWidget field, int min, int max) {
        try {
            boolean valid;
            int value = Integer.parseInt(field.func_146179_b());
            boolean bl = valid = value >= min && value <= max;
            if (valid) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketSetFuzzyPlacementChance(value));
                this.chance = String.valueOf(value);
            } else {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketSetFuzzyPlacementChance(max));
                this.chance = String.valueOf(max);
                field.func_146180_a(String.valueOf(max));
            }
        }
        catch (NumberFormatException exception) {
            NetworkHandler.INSTANCE.sendToServer((Object)new PacketSetFuzzyPlacementChance(max));
            this.chance = String.valueOf(max);
            field.func_146180_a(String.valueOf(max));
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231178_ax__() {
        return false;
    }
}

