/*
 * Decompiled with CFR 0.152.
 */
package jackyy.gunpowderlib.helper;

import java.text.NumberFormat;
import java.util.Optional;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class StringHelper {
    public static IFormattableTextComponent getTierText(String modid, int tier) {
        return StringHelper.localize(modid, "tooltip.tier", tier);
    }

    public static IFormattableTextComponent getShiftText(String modid) {
        return StringHelper.localize(modid, "tooltip.hold_shift", StringHelper.localize(modid, "tooltip.hold_shift.shift", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.ITALIC})).func_240699_a_(TextFormatting.GRAY);
    }

    public static IFormattableTextComponent getCtrlText(String modid) {
        return StringHelper.localize(modid, "tooltip.hold_ctrl", StringHelper.localize(modid, "tooltip.hold_ctrl.ctrl", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC})).func_240699_a_(TextFormatting.GRAY);
    }

    public static IFormattableTextComponent formatNumber(long number) {
        return new StringTextComponent(NumberFormat.getInstance().format(number));
    }

    public static String getModNameByID(String modid) {
        Optional modContainer = ModList.get().getModContainerById(modid);
        if (modContainer.isPresent()) {
            return ((ModContainer)modContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    public static IFormattableTextComponent formatHarvestLevel(String modid, int harvestLevel) {
        return StringHelper.localize(modid, "harvest_level." + harvestLevel, new Object[0]).toString().equals(modid + ".harvest_level." + harvestLevel) ? new StringTextComponent(String.valueOf(harvestLevel)) : StringHelper.localize(modid, "harvest_level." + harvestLevel, new Object[0]);
    }

    public static IFormattableTextComponent localize(String modid, String unlocalized, Object ... args) {
        String toLocalize = modid + "." + unlocalized;
        if (args != null && args.length > 0) {
            return new TranslationTextComponent(toLocalize, args);
        }
        return new TranslationTextComponent(toLocalize);
    }
}

