/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.world.structures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tardis.mod.Tardis;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.world.structures.AbandonedSpaceshipStructure;
import net.tardis.mod.world.structures.AbandonedSpaceshipStructurePieces;
import net.tardis.mod.world.structures.CrashedStructure;
import net.tardis.mod.world.structures.CrashedStructurePieces;
import net.tardis.mod.world.structures.DalekShipStructure;
import net.tardis.mod.world.structures.DalekShipStructurePieces;
import net.tardis.mod.world.structures.MoonLanderStructure;
import net.tardis.mod.world.structures.MoonLanderStructurePieces;
import net.tardis.mod.world.structures.SpaceStationStructure;
import net.tardis.mod.world.structures.SpaceStationStructurePieces;

public class TStructures {
    public static void setupStructures() {
        TStructures.setupStructure((Structure)Structures.CRASHED_STRUCTURE.get(), new StructureSeparationSettings(((Integer)TConfig.COMMON.crashedStructureSpacing.get()).intValue(), ((Integer)TConfig.COMMON.crashedStructureSeperation.get()).intValue(), 1234567890), false);
        TStructures.setupStructure((Structure)Structures.SPACE_STATION_DRONE.get(), new StructureSeparationSettings(((Integer)TConfig.COMMON.spaceStationMissionSpacing.get()).intValue(), ((Integer)TConfig.COMMON.spaceStationMissionSeperation.get()).intValue(), 1234562890), false);
        TStructures.setupStructure((Structure)Structures.DALEK_SHIP.get(), new StructureSeparationSettings(((Integer)TConfig.COMMON.dalekSaucerSpacing.get()).intValue(), ((Integer)TConfig.COMMON.dalekSaucerSeperation.get()).intValue(), 1234567890), false);
        TStructures.setupStructure((Structure)Structures.ABANDONED_SPACESHIP.get(), new StructureSeparationSettings(((Integer)TConfig.COMMON.abandonedSpaceshipSpacing.get()).intValue(), ((Integer)TConfig.COMMON.abandonedSpaceshipSeperation.get()).intValue(), 1234567890), false);
        TStructures.setupStructure((Structure)Structures.MOON_LANDER.get(), new StructureSeparationSettings(((Integer)TConfig.COMMON.moonLanderSpacing.get()).intValue(), ((Integer)TConfig.COMMON.moonLanderSeperation.get()).intValue(), 1234567890), true);
    }

    private static <T extends Structure<?>> void registerConfiguredStructure(String registryName, Supplier<T> structure, StructureFeature<?, ?> configuredStructure) {
        Registry registry = WorldGenRegistries.field_243654_f;
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("tardis", registryName), configuredStructure);
        FlatGenerationSettings.field_202247_j.put(structure.get(), configuredStructure);
    }

    private static <T extends Structure<?>> RegistryObject<T> setupStructure(String name, Supplier<T> structure) {
        return Structures.STRUCTURES.register(name, structure);
    }

    public static <F extends Structure<?>> void setupStructure(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        if (structureSeparationSettings.func_236668_a_() <= structureSeparationSettings.func_236671_b_()) {
            String errorMessage = String.format("Structure Spacing must be larger then Structure Seperation values!\nStructure ID: %s\nInput Spacing: %s, Input Seperation: %s.\nThis is an intentional error message!\nPlease check your tardis-common.toml config options!\nPlease note: the vanilla warning of 'Spacing has to be smaller than separation' is wrong!", structure.getRegistryName().toString(), structureSeparationSettings.func_236668_a_(), structureSeparationSettings.func_236671_b_());
            Tardis.LOGGER.error(errorMessage);
        }
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        if (ModList.get().isLoaded("terraforged")) {
            TStructures.addHackyStructureModCompat(structure, structureSeparationSettings);
        }
    }

    public static IStructurePieceType registerStructurePiece(IStructurePieceType type, String key) {
        return (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("tardis", key), (Object)type);
    }

    public static <F extends Structure<?>> void addHackyStructureModCompat(F structure, StructureSeparationSettings structureSeparationSettings) {
        WorldGenRegistries.field_243658_j.forEach(settings -> {
            Map structureMap = settings.func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                settings.func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
            Tardis.LOGGER.info("Added compatibility with other world generation mods for structure {}: Adding StructureSeperationSettings early into WorldGenRegistries!", (Object)structure.getRegistryName().toString());
            Tardis.LOGGER.info("Warning: This may break compatibility with vanilla datapacks!");
        });
    }

    static /* synthetic */ RegistryObject access$000(String x0, Supplier x1) {
        return TStructures.setupStructure(x0, x1);
    }

    public static class ConfiguredStructures {
        public static StructureFeature<?, ?> CONFIGURED_CRASHED_STRUCTURE = ((Structure)Structures.CRASHED_STRUCTURE.get()).func_236391_a_((IFeatureConfig)new ProbabilityConfig(Helper.getConfigPercent((Integer)TConfig.COMMON.crashedStructureSpawnChance.get())));
        public static StructureFeature<?, ?> CONFIGURED_SPACE_STATION_DRONE = ((Structure)Structures.SPACE_STATION_DRONE.get()).func_236391_a_((IFeatureConfig)new ProbabilityConfig(Helper.getConfigPercent((Integer)TConfig.COMMON.spaceStationMissionSpawnChance.get())));
        public static StructureFeature<?, ?> CONFIGURED_DALEK_SHIP = ((Structure)Structures.DALEK_SHIP.get()).func_236391_a_((IFeatureConfig)new ProbabilityConfig(Helper.getConfigPercent((Integer)TConfig.COMMON.dalekSaucerSpawnChance.get())));
        public static final RegistryKey<StructureFeature<?, ?>> SPACE_STATION_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243553_av, (ResourceLocation)new ResourceLocation("tardis", "space_station_drone"));
        public static StructureFeature<?, ?> CONFIGURED_ABANDONED_SPACESHIP = ((Structure)Structures.ABANDONED_SPACESHIP.get()).func_236391_a_((IFeatureConfig)new ProbabilityConfig(Helper.getConfigPercent((Integer)TConfig.COMMON.abandonedSpaceshipSpawnChance.get())));
        public static StructureFeature<?, ?> CONFIGURED_MOON_LANDER = ((Structure)Structures.MOON_LANDER.get()).func_236391_a_((IFeatureConfig)new ProbabilityConfig(Helper.getConfigPercent((Integer)TConfig.COMMON.moonLanderSpawnChance.get())));

        public static void registerConfiguredStructures() {
            TStructures.registerConfiguredStructure("crashed_structure", Structures.CRASHED_STRUCTURE, ConfiguredStructures.CONFIGURED_CRASHED_STRUCTURE);
            TStructures.registerConfiguredStructure("space_station_drone", Structures.SPACE_STATION_DRONE, ConfiguredStructures.CONFIGURED_SPACE_STATION_DRONE);
            TStructures.registerConfiguredStructure("dalek_ship", Structures.DALEK_SHIP, ConfiguredStructures.CONFIGURED_DALEK_SHIP);
            TStructures.registerConfiguredStructure("abandoned_spaceship", Structures.ABANDONED_SPACESHIP, ConfiguredStructures.CONFIGURED_ABANDONED_SPACESHIP);
            TStructures.registerConfiguredStructure("moon_lander", Structures.MOON_LANDER, ConfiguredStructures.CONFIGURED_MOON_LANDER);
        }
    }

    public static class Structures {
        public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"tardis");
        public static final RegistryObject<Structure<ProbabilityConfig>> DALEK_SHIP = TStructures.access$000("dalek_ship", () -> new DalekShipStructure((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
        public static IStructurePieceType DALEK_SHIP_PIECE = TStructures.registerStructurePiece(DalekShipStructurePieces.Piece::new, "dalek_ship_piece");
        public static final RegistryObject<Structure<ProbabilityConfig>> CRASHED_STRUCTURE = TStructures.access$000("crashed_structure", () -> new CrashedStructure((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
        public static IStructurePieceType CRASHED_PIECE = TStructures.registerStructurePiece(CrashedStructurePieces.Piece::new, "crashed_piece");
        public static final RegistryObject<Structure<ProbabilityConfig>> SPACE_STATION_DRONE = TStructures.access$000("space_station_drone", () -> new SpaceStationStructure((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
        public static IStructurePieceType SPACE_STATION_DRONE_PIECE = TStructures.registerStructurePiece(SpaceStationStructurePieces.Piece::new, "space_station_drone_piece");
        public static final RegistryKey<Structure<?>> SPACE_STATION_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239671_I_, (ResourceLocation)new ResourceLocation("tardis", "space_station_drone"));
        public static final RegistryObject<Structure<ProbabilityConfig>> ABANDONED_SPACESHIP = TStructures.access$000("abandoned_spaceship", () -> new AbandonedSpaceshipStructure((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
        public static IStructurePieceType ABANDONED_SPACESHIP_PIECE = TStructures.registerStructurePiece(AbandonedSpaceshipStructurePieces.Piece::new, "abandoned_spaceship_piece");
        public static final RegistryKey<Structure<?>> MOON_LANDER_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239671_I_, (ResourceLocation)new ResourceLocation("tardis", "moon_lander"));
        public static final RegistryObject<Structure<ProbabilityConfig>> MOON_LANDER = TStructures.access$000("moon_lander", () -> new MoonLanderStructure((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
        public static IStructurePieceType MOON_LANDER_PIECE = TStructures.registerStructurePiece(MoonLanderStructurePieces.Piece::new, "moon_lander");
    }
}

