/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.world.structures;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.humanoid.CrewmateEntity;
import net.tardis.mod.entity.humanoid.ShipCaptainEntity;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.loottables.TardisLootTables;
import net.tardis.mod.missions.MiniMission;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.MissionUpdateMessage;
import net.tardis.mod.registries.MissionRegistry;
import net.tardis.mod.schematics.Schematics;
import net.tardis.mod.world.structures.TStructures;

public class SpaceStationStructurePieces {
    private static final ResourceLocation SPACE_STATION_WITH_DRONE = new ResourceLocation("tardis", "space/spacestation_drone");
    private static final ResourceLocation[] ALL_STRUCTURES = new ResourceLocation[]{SPACE_STATION_WITH_DRONE};
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)SPACE_STATION_WITH_DRONE, (Object)BlockPos.field_177992_a);

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
        pieceList.add((StructurePiece)new Piece(templateManager, ALL_STRUCTURES[random.nextInt(ALL_STRUCTURES.length)], blockpos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation resourceLocation;
        private final Rotation rotation;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(TStructures.Structures.SPACE_STATION_DRONE_PIECE, 0);
            this.resourceLocation = resourceLocationIn;
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.rotation = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(TStructures.Structures.SPACE_STATION_DRONE_PIECE, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("captain_spawn".equals(function)) {
                BlockPos entCap = pos.func_185334_h();
                ShipCaptainEntity cap = (ShipCaptainEntity)((EntityType)TEntities.SHIP_CAPTAIN.get()).func_200721_a((World)worldIn.func_201672_e());
                cap.func_70107_b((double)entCap.func_177958_n() + 0.5, entCap.func_177956_o() + 1, (double)entCap.func_177952_p() + 0.5);
                cap.func_213386_a((IServerWorld)worldIn.func_201672_e(), worldIn.func_175649_E(entCap), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)cap);
                worldIn.func_217377_a(pos, false);
            }
            if ("mission_marker".equals(function)) {
                ServerWorld serverWorld = worldIn.func_201672_e();
                serverWorld.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(0, () -> serverWorld.getCapability(Capabilities.MISSION).ifPresent(missions -> {
                    MiniMission mis = ((MiniMissionType)MissionRegistry.STATION_DRONE.get()).create((World)serverWorld.getWorldServer(), pos, 64);
                    missions.addMission(mis);
                    Network.sendToAllInWorld(new MissionUpdateMessage(mis), worldIn.func_201672_e());
                })));
                worldIn.func_217377_a(pos, false);
            }
            if ("crewmates".equals(function)) {
                int num = 5 + worldIn.func_201674_k().nextInt(3);
                for (int i = 0; i < num; ++i) {
                    CrewmateEntity entity = (CrewmateEntity)((EntityType)TEntities.CREWMATE.get()).func_200721_a((World)worldIn.func_201672_e());
                    entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
                    entity.func_213386_a((IServerWorld)worldIn.func_201672_e(), worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                    worldIn.func_217376_c((Entity)entity);
                }
                worldIn.func_217377_a(pos, false);
            }
            if ("tardis:spacestation_lab_loot_1".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, TardisLootTables.SPACESTATION_DRONE);
                Helper.addSchematicToComputerBelow(worldIn, pos, Schematics.Exteriors.TT_2020.getId());
            }
            if ("tardis:spacestation_central_loot_1".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, TardisLootTables.SPACESTATION_DRONE);
            }
            if ("tardis:spacestation_central_loot_2".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, TardisLootTables.SPACESTATION_DRONE);
            }
            if ("tardis:spacestation_central_loot_3".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, TardisLootTables.CRASHED_SHIP);
            }
            if ("tardis:spacestation_central_loot_4".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, TardisLootTables.SPACESTATION_DRONE);
            }
        }
    }
}

