/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.world.structures;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.loottables.TardisLootTables;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.Schematics;
import net.tardis.mod.tileentities.ShipComputerTile;
import net.tardis.mod.world.structures.TStructures;

public class DalekShipStructurePieces {
    private static final ResourceLocation DALEK_SHIP = new ResourceLocation("tardis", "space/dalek_mothership");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)DALEK_SHIP, (Object)BlockPos.field_177992_a);

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
        pieceList.add((StructurePiece)new Piece(templateManager, DALEK_SHIP, blockpos, rotation));
    }

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, ResourceLocation templateRL) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
        pieceList.add((StructurePiece)new Piece(templateManager, templateRL, blockpos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation resourceLocation;
        private final Rotation rotation;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(TStructures.Structures.DALEK_SHIP_PIECE, 0);
            this.resourceLocation = resourceLocationIn;
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.rotation = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(TStructures.Structures.DALEK_SHIP_PIECE, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            BlockPos spawnPos;
            ShipComputerTile computer;
            TileEntity te;
            if ("schematic".equals(function) && (te = worldIn.func_175625_s(pos.func_177977_b())) instanceof ShipComputerTile) {
                computer = (ShipComputerTile)te;
                computer.setSchematic(this.getRandomSchematic(worldIn.func_201674_k(), this.getPossibleInteriorSchematics()).getId());
                computer.setLootTable(TardisLootTables.SPACESTATION_DRONE);
                worldIn.func_217377_a(pos, false);
            }
            if ("schematic_exterior".equals(function) && (te = worldIn.func_175625_s(pos.func_177977_b())) instanceof ShipComputerTile) {
                computer = (ShipComputerTile)te;
                computer.setSchematic(this.getRandomSchematic(worldIn.func_201674_k(), this.getPossibleExteriorSchematics()).getId());
                computer.setLootTable(TardisLootTables.CRASHED_SHIP);
                worldIn.func_217377_a(pos, false);
            }
            if ("airlock_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, new ResourceLocation("minecraft:chests/desert_pyramid"));
            }
            if ("bridge_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, TardisLootTables.DALEK_SHIP);
            }
            if ("bridge_loot_alt".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, new ResourceLocation("minecraft:chests/end_city_treasure"));
            }
            if ("bridge_entrance_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, new ResourceLocation("minecraft:chests/bastion_treasure"));
            }
            if ("cell_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, new ResourceLocation("minecraft:chests/ruined_portal"));
            }
            if ("outer_misc_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, new ResourceLocation("minecraft:chests/woodland_mansion"));
            }
            if ("outer_corridor_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, new ResourceLocation("minecraft:chests/simple_dungeon"));
            }
            if ("outer_corridor_loot_alt".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, new ResourceLocation("minecraft:chests/bastion_other"));
            }
            if ("transmat_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, new ResourceLocation("minecraft:chests/bastion_hoglin_stable"));
            }
            if ("turret_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, new ResourceLocation("minecraft:chests/woodland_mansion"));
            }
            if ("dalek_spawn".equals(function)) {
                spawnPos = pos.func_185334_h();
                DalekEntity dalek = (DalekEntity)((EntityType)TEntities.DALEK.get()).func_200721_a((World)worldIn.func_201672_e());
                dalek.func_70107_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o() + 1, (double)spawnPos.func_177952_p() + 0.5);
                dalek.func_213386_a((IServerWorld)worldIn.func_201672_e(), worldIn.func_175649_E(spawnPos), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)dalek);
                worldIn.func_217377_a(pos, false);
            }
            if ("illager_spawn".equals(function)) {
                spawnPos = pos.func_185334_h();
                PillagerEntity pillager = (PillagerEntity)EntityType.field_220350_aJ.func_200721_a((World)worldIn.func_201672_e());
                pillager.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)(spawnPos.func_177956_o() + 1), (double)spawnPos.func_177952_p() + 0.5);
                pillager.func_213386_a((IServerWorld)worldIn.func_201672_e(), worldIn.func_175649_E(spawnPos), SpawnReason.PATROL, null, null);
                pillager.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                worldIn.func_217376_c((Entity)pillager);
                worldIn.func_217377_a(pos, false);
            }
        }

        public Schematic[] getPossibleExteriorSchematics() {
            return new Schematic[]{Schematics.Exteriors.POLICE_BOX, Schematics.Exteriors.POLICE_BOX_MODERN};
        }

        public Schematic[] getPossibleInteriorSchematics() {
            return new Schematic[]{Schematics.Interiors.TOYOTA, Schematics.Interiors.CORAL};
        }

        public Schematic getRandomSchematic(Random rand, Schematic[] schematics) {
            return schematics[rand.nextInt(schematics.length)];
        }
    }
}

