/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.world.structures;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.loottables.TardisLootTables;
import net.tardis.mod.world.structures.TStructures;

public class AbandonedSpaceshipStructurePieces {
    private static final ResourceLocation SPACESHIP = new ResourceLocation("tardis", "space/spaceship_explorer");
    private static final ResourceLocation SHUTTLE = new ResourceLocation("tardis", "space/shuttle");
    private static final ResourceLocation[] ALL_STRUCTURES = new ResourceLocation[]{SPACESHIP, SHUTTLE};
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)SPACESHIP, (Object)BlockPos.field_177992_a, (Object)SHUTTLE, (Object)BlockPos.field_177992_a);

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
        pieceList.add((StructurePiece)new Piece(templateManager, ALL_STRUCTURES[random.nextInt(ALL_STRUCTURES.length)], blockpos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation resourceLocation;
        private final Rotation rotation;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(TStructures.Structures.ABANDONED_SPACESHIP_PIECE, 0);
            this.resourceLocation = resourceLocationIn;
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.rotation = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(TStructures.Structures.ABANDONED_SPACESHIP_PIECE, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("explorer_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, TardisLootTables.CRASHED_SHIP);
            }
            if ("shuttle_loot".equals(function)) {
                Helper.addLootToComputerBelow(worldIn, pos, TardisLootTables.OBSERVATORY_LOOT);
            }
        }
    }
}

