/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.world.WorldGen;

public class TardisGenFeature
extends Feature<ProbabilityConfig> {
    public TardisGenFeature(Codec<ProbabilityConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader iSeedReader, ChunkGenerator chunkGenerator, Random rand, BlockPos pos, ProbabilityConfig config) {
        if (((MutableRegistry)iSeedReader.func_241828_r().func_230521_a_(Registry.field_239720_u_).get()).func_230519_c_((Object)iSeedReader.func_226691_t_(pos)).get() == Biomes.field_185440_P) {
            return false;
        }
        if (WorldHelper.canBrokenTardisSpawn((RegistryKey<World>)iSeedReader.func_201672_e().func_234923_W_())) {
            for (int y = 0; y < 30; ++y) {
                BlockPos test = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                boolean water = iSeedReader.func_204610_c(test).getFluidState().func_206884_a((ITag)FluidTags.field_206959_a);
                AxisAlignedBB spawnBox = new AxisAlignedBB(test).func_72314_b(1.0, 0.0, 1.0);
                if (!BlockPos.func_239581_a_((AxisAlignedBB)spawnBox).allMatch(testPos -> {
                    BlockState state = iSeedReader.func_180495_p(testPos);
                    return state.isAir((IBlockReader)iSeedReader, testPos);
                }) || iSeedReader.func_175710_j(test.func_177977_b()) || !iSeedReader.func_180495_p(test.func_177977_b()).func_200132_m() || !(rand.nextFloat() <= config.field_203622_a)) continue;
                BlockState state = ((Block)TBlocks.broken_exterior.get()).func_176223_P();
                if (water) {
                    state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                }
                BlockPos extPos = test.func_177984_a();
                iSeedReader.func_180501_a(extPos, state, 2);
                WorldGen.BROKEN_EXTERIORS.add(extPos);
                return true;
            }
        }
        return false;
    }
}

