/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.world.feature;

import com.mojang.serialization.Codec;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.world.feature.CratorFeature;
import net.tardis.mod.world.feature.TardisGenFeature;
import net.tardis.mod.world.feature.XionCrystalFeature;

public class TFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"tardis");
    public static final RegistryObject<Feature<OreFeatureConfig>> CINNABAR_ORE = FEATURES.register("cinnabar_ore", () -> new OreFeature(OreFeatureConfig.field_236566_a_));
    public static final RegistryObject<Feature<ProbabilityConfig>> XION_CRYSTAL = FEATURES.register("xion_crystal", () -> new XionCrystalFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
    public static final RegistryObject<Feature<ProbabilityConfig>> MOON_CRATOR = FEATURES.register("moon_crator", () -> new CratorFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
    public static final RegistryObject<Feature<ProbabilityConfig>> BROKEN_EXTERIOR = FEATURES.register("broken_exterior", () -> new TardisGenFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));

    public static void registerConfiguredFeatures() {
        TFeatures.registerConfiguredFeature("cinnabar_ore", ConfiguredFeatures.CONFIGURED_CINNABAR_ORE);
        TFeatures.registerConfiguredFeature("xion_crystal", ConfiguredFeatures.CONFIGURED_XION_CRYSTAL);
        TFeatures.registerConfiguredFeature("moon_crator", ConfiguredFeatures.CONFIGURED_MOON_CRATOR);
        TFeatures.registerConfiguredFeature("broken_exterior", ConfiguredFeatures.CONFIGURED_BROKEN_EXTERIOR);
    }

    private static <T extends Feature<?>> void registerConfiguredFeature(String registryName, ConfiguredFeature<?, ?> configuredFeature) {
        Registry registry = WorldGenRegistries.field_243653_e;
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("tardis", registryName), configuredFeature);
    }

    public static class ConfiguredFeatures {
        public static final ConfiguredFeature<?, ?> CONFIGURED_CINNABAR_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)CINNABAR_ORE.get()).func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)TBlocks.cinnabar_ore.get()).func_176223_P(), 5)).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(((Integer)TConfig.COMMON.cinnabarOreSpawnChance.get()).intValue()))).func_242733_d(64)).func_242728_a()).func_242731_b(5);
        public static final ConfiguredFeature<?, ?> CONFIGURED_XION_CRYSTAL = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)XION_CRYSTAL.get()).func_225566_b_((IFeatureConfig)new ProbabilityConfig(Helper.getConfigPercent((Integer)TConfig.COMMON.xionCrystalSpawnChance.get()))).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(6, 5, 32))).func_242733_d(16)).func_242728_a()).func_242731_b(8);
        public static final ConfiguredFeature<?, ?> CONFIGURED_MOON_CRATOR = (ConfiguredFeature)((Feature)MOON_CRATOR.get()).func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.1f)).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(14))).func_242728_a();
        public static final ConfiguredFeature<?, ?> CONFIGURED_BROKEN_EXTERIOR = (ConfiguredFeature)((Feature)BROKEN_EXTERIOR.get()).func_225566_b_((IFeatureConfig)new ProbabilityConfig(Helper.getConfigPercent((Integer)TConfig.COMMON.tardisSpawnProbability.get()))).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(6, 0, 64))).func_242728_a();
    }
}

