/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.world.dimensions;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tardis.mod.Tardis;
import net.tardis.mod.helper.DimensionHelper;
import net.tardis.mod.world.data.TardisWorldData;
import net.tardis.mod.world.dimensions.SpaceChunkGenerator;
import net.tardis.mod.world.dimensions.TardisChunkGenerator;
import net.tardis.mod.world.dimensions.VortexChunkGenerator;

@Mod.EventBusSubscriber(modid="tardis", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TDimensions {
    public static List<RegistryKey<World>> TARDIS_DIMENSIONS = new ArrayList<RegistryKey<World>>();
    public static final RegistryKey<World> VORTEX_DIM = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("tardis", "vortex"));
    public static final RegistryKey<World> MOON_DIM = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("tardis", "moon"));
    public static final RegistryKey<World> SPACE_DIM = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("tardis", "space"));
    public static final ResourceLocation TARDIS_SKY_PROPERTY_KEY = new ResourceLocation("tardis", "tardis_sky_property");
    public static final ResourceLocation VORTEX_SKY_PROPERTY_KEY = new ResourceLocation("tardis", "vortex_sky_property");
    public static final ResourceLocation MOON_SKY_PROPERTY_KEY = new ResourceLocation("tardis", "moon_sky_property");
    public static final ResourceLocation SPACE_SKY_PROPERTY_KEY = new ResourceLocation("tardis", "space_sky_property");
    public static RegistryKey<DimensionSettings> TARDIS_NOISE_SETTINGS;
    public static RegistryKey<DimensionSettings> MOON_NOISE_SETTINGS;
    public static RegistryKey<DimensionSettings> VORTEX_NOISE_SETTINGS;
    public static RegistryKey<DimensionSettings> SPACE_NOISE_SETTINGS;

    public static void registerNoiseSettings() {
        MOON_NOISE_SETTINGS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)new ResourceLocation("tardis", "moon"));
        VORTEX_NOISE_SETTINGS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)new ResourceLocation("tardis", "vortex"));
        SPACE_NOISE_SETTINGS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)new ResourceLocation("tardis", "space"));
        TARDIS_NOISE_SETTINGS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)Tardis.TARDIS_LOC);
    }

    public static void registerChunkGenerators() {
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)Tardis.TARDIS_LOC, TardisChunkGenerator.providerCodec);
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("tardis", "vortex"), VortexChunkGenerator.providerCodec);
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("tardis", "space"), SpaceChunkGenerator.providerCodec);
    }

    public static Dimension tardisDimensionBuilder(MinecraftServer server, RegistryKey<Dimension> dimensionKey) {
        long seed = server.func_71218_a(World.field_234918_g_).func_72905_C() + (long)dimensionKey.func_240901_a_().hashCode();
        DynamicRegistries registries = server.func_244267_aX();
        MutableRegistry noiseRegistry = registries.func_243612_b(Registry.field_243549_ar);
        MutableRegistry biomeRegistry = registries.func_243612_b(Registry.field_239720_u_);
        return new Dimension(() -> (DimensionType)registries.func_243612_b(Registry.field_239698_ad_).func_243576_d(DimensionTypes.TARDIS_TYPE), (ChunkGenerator)new TardisChunkGenerator(server));
    }

    public static ServerWorld registerOrGetDimensionStatic(String name, MinecraftServer server, BiFunction<MinecraftServer, RegistryKey<Dimension>, Dimension> dimension) {
        ResourceLocation loc = new ResourceLocation("tardis", name);
        RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)loc);
        ServerWorld newWorld = DimensionHelper.getOrCreateWorldStatic(server, (RegistryKey<World>)worldKey, dimension);
        return newWorld;
    }

    public static ServerWorld registerOrGetDimensionStatic(RegistryKey<World> worldKey, MinecraftServer server, BiFunction<MinecraftServer, RegistryKey<Dimension>, Dimension> dimension) {
        ServerWorld newWorld = DimensionHelper.getOrCreateWorldStatic(server, worldKey, dimension);
        return newWorld;
    }

    public static ServerWorld registerOrGetTardisDim(String name, MinecraftServer server) {
        ResourceLocation loc = new ResourceLocation("tardis", name);
        RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)loc);
        ServerWorld newWorld = DimensionHelper.getOrCreateWorld(server, (RegistryKey<World>)worldKey, TDimensions::tardisDimensionBuilder);
        if (server.func_71218_a(worldKey) != null) {
            return newWorld;
        }
        TARDIS_DIMENSIONS.add((RegistryKey<World>)worldKey);
        if (Events.DATA != null) {
            Events.DATA.func_76185_a();
        }
        return newWorld;
    }

    public static void registerOldTardises(MinecraftServer server) {
        for (RegistryKey<World> world : TARDIS_DIMENSIONS) {
            if (server.func_71218_a(world) != null) continue;
            DimensionHelper.getOrCreateWorldStatic(server, world, TDimensions::tardisDimensionBuilder);
            if (TARDIS_DIMENSIONS.contains(world)) continue;
            TARDIS_DIMENSIONS.add(world);
        }
    }

    @Mod.EventBusSubscriber(modid="tardis")
    public static class Events {
        static TardisWorldData DATA;

        @SubscribeEvent
        public static void saveTardisDimensions(WorldEvent.Save event) {
            if (!(event.getWorld() instanceof ServerWorld)) {
                return;
            }
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_234923_W_() == World.field_234918_g_) {
                ((ServerWorld)event.getWorld()).func_217481_x().func_215757_a((WorldSavedData)DATA);
            }
        }

        @SubscribeEvent
        public static void load(WorldEvent.Load event) {
            if (!(event.getWorld() instanceof ServerWorld)) {
                return;
            }
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_234923_W_() == World.field_234918_g_) {
                DATA = (TardisWorldData)((ServerWorld)event.getWorld()).func_217481_x().func_215752_a(TardisWorldData::new, "tardis");
                TDimensions.registerOldTardises(serverWorld.func_73046_m());
            }
        }

        @SubscribeEvent
        public static void unload(WorldEvent.Unload event) {
            if (!(event.getWorld() instanceof ServerWorld)) {
                return;
            }
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_234923_W_() == World.field_234918_g_) {
                TARDIS_DIMENSIONS.clear();
            }
        }
    }

    public static class DimensionTypes {
        public static final RegistryKey<DimensionType> TARDIS_TYPE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)Tardis.TARDIS_LOC);
        public static final RegistryKey<DimensionType> MOON_TYPE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)new ResourceLocation("tardis", "moon"));
        public static final RegistryKey<DimensionType> VORTEX_TYPE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)new ResourceLocation("tardis", "vortex"));
        public static final RegistryKey<DimensionType> SPACE_TYPE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)new ResourceLocation("tardis", "space"));
    }
}

