/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.raid.Raid;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.helper.Helper;

public class WorldGen {
    public static List<BlockPos> BROKEN_EXTERIORS = new ArrayList<BlockPos>();

    private static void addStructureToTemplatePool(MutableRegistry<JigsawPattern> templatePoolRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        JigsawPattern pool = (JigsawPattern)templatePoolRegistry.func_82594_a(poolRL);
        if (pool == null) {
            return;
        }
        SingleJigsawPiece piece = (SingleJigsawPiece)SingleJigsawPiece.func_242859_b((String)nbtPieceRL).apply(JigsawPattern.PlacementBehaviour.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.field_214953_e.add(piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.field_214952_d);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.field_214952_d = listOfPieceEntries;
    }

    private static void addObservatoryStreetToPools(MutableRegistry<JigsawPattern> templatePoolRegistry, String biome, int weight) {
        WorldGen.addStructureToTemplatePool(templatePoolRegistry, new ResourceLocation("minecraft:village/" + biome + "/streets"), new ResourceLocation("tardis", "village/" + biome + "/streets/observatory_street_" + biome).toString(), weight);
    }

    public static void addStructuresToJigsawPools(FMLServerAboutToStartEvent event) {
        MutableRegistry templatePoolRegistry = event.getServer().func_244267_aX().func_243612_b(Registry.field_243555_ax);
        WorldGen.addObservatoryStreetToPools((MutableRegistry<JigsawPattern>)templatePoolRegistry, "plains", (Integer)TConfig.COMMON.observatorySpawnWeightPlains.get());
        WorldGen.addObservatoryStreetToPools((MutableRegistry<JigsawPattern>)templatePoolRegistry, "desert", (Integer)TConfig.COMMON.observatorySpawnWeightDesert.get());
        WorldGen.addObservatoryStreetToPools((MutableRegistry<JigsawPattern>)templatePoolRegistry, "savanna", (Integer)TConfig.COMMON.observatorySpawnWeightSavanna.get());
    }

    @Nullable
    public static BlockPos getClosestBrokenExterior(int x, int y) {
        int dist = Integer.MAX_VALUE;
        BlockPos ext = null;
        for (BlockPos pos : BROKEN_EXTERIORS) {
            BlockPos blockPos = new BlockPos(x, 0, y);
            if (!(pos.func_177951_i((Vector3i)blockPos) < (double)dist)) continue;
            ext = pos;
        }
        if (BROKEN_EXTERIORS.contains(ext)) {
            BROKEN_EXTERIORS.remove(ext);
        }
        return ext;
    }

    public static void addEntitiesToRaids() {
        if (((Boolean)TConfig.COMMON.dalekJoinVillageRaid.get()).booleanValue()) {
            int[] dalekRaidCount = Helper.toIntArray((List)TConfig.COMMON.dalekVillageRaidSpawnCount.get());
            Raid.WaveMember.create((String)new ResourceLocation("tardis", "dalek_raiders").toString(), (EntityType)((EntityType)TEntities.DALEK.get()), (int[])dalekRaidCount);
        }
    }
}

