/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.upgrades;

import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.ITardisWorldData;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.IEngineTogglable;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ConsoleUpdateMessage;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.network.packets.console.UpgradeData;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.inventory.PanelInventory;
import net.tardis.mod.upgrades.UpgradeEntry;

public abstract class Upgrade
implements IEngineTogglable {
    private UpgradeEntry entry;
    private ConsoleTile console;
    private ItemStack stack;
    private Class<? extends Subsystem> parent;
    private boolean isActive = true;

    protected Upgrade(UpgradeEntry entry, ConsoleTile tile, Class<? extends Subsystem> clazz) {
        this.entry = entry;
        this.console = tile;
        this.parent = clazz;
    }

    public ConsoleTile getConsole() {
        TileEntity te;
        if (this.console != null && !this.console.func_145837_r()) {
            return this.console;
        }
        if (this.console != null && this.console.func_145831_w() != null && (te = this.console.func_145831_w().func_175625_s(TardisHelper.TARDIS_POS)) instanceof ConsoleTile) {
            return (ConsoleTile)te;
        }
        return null;
    }

    public UpgradeEntry getEntry() {
        return this.entry;
    }

    public ItemStack getStack() {
        if (this.stack == null || this.stack.func_190926_b()) {
            this.stack = this.getStackFromWorld(this.console.func_145831_w());
            return this.stack;
        }
        return this.stack;
    }

    private ItemStack getStackFromWorld(World world) {
        ITardisWorldData data = (ITardisWorldData)world.getCapability(Capabilities.TARDIS_DATA).orElse(null);
        if (data != null) {
            PanelInventory inv = data.getEngineInventoryForSide(Direction.SOUTH);
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (inv.getStackInSlot(i).getStack().func_77973_b() != this.getEntry().getItem()) continue;
                return inv.getStackInSlot(i);
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean isUsable() {
        return !this.getStack().func_190926_b();
    }

    public void damage(int amount, DamageType type, @Nullable ServerPlayerEntity entity) {
        if (type == DamageType.ITEM || type == DamageType.BOTH) {
            this.getStack().func_96631_a(amount, this.getConsole().func_145831_w().field_73012_v, entity);
        }
        if ((type == DamageType.PARENT || type == DamageType.BOTH) && this.parent != null) {
            this.console.getSubsystem(this.parent).ifPresent(sys -> sys.damage(entity, amount));
        }
        if (this.getStack().func_77952_i() >= this.getStack().func_77958_k()) {
            this.console.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> {
                PanelInventory inv = cap.getEngineInventoryForSide(Direction.SOUTH);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    if (inv.getStackInSlot(i).func_77973_b() != this.getEntry().getItem()) continue;
                    inv.setStackInSlot(i, ItemStack.field_190927_a);
                    break;
                }
            });
        }
        if (!this.isUsable()) {
            this.onBreak();
        }
    }

    public abstract void onLand();

    public abstract void onTakeoff();

    public abstract void onFlightSecond();

    public void onBreak() {
    }

    @Override
    public void setActivated(boolean active) {
        this.isActive = active;
    }

    @Override
    public boolean isActivated() {
        return this.isActive;
    }

    public void update() {
        Network.sendToTrackingTE(new ConsoleUpdateMessage(DataTypes.UPGRADE, new UpgradeData(this.entry.getRegistryName(), this.isActive)), this.getConsole());
    }

    public static enum DamageType {
        BOTH,
        PARENT,
        ITEM;

    }
}

