/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.upgrades;

import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.controls.LandingTypeControl;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.items.TimeLinkUpgradeItem;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.upgrades.Upgrade;
import net.tardis.mod.upgrades.UpgradeEntry;

public class TimeLinkUpgrade
extends Upgrade {
    private Optional<ConsoleTile> slave = Optional.empty();

    public TimeLinkUpgrade(UpgradeEntry entry, ConsoleTile tile, Class<? extends Subsystem> clazz) {
        super(entry, tile, clazz);
    }

    @Override
    public void onLand() {
        if (this.isUsable() && this.isActivated()) {
            if (!this.slave.isPresent()) {
                this.findSlave();
            }
            this.slave.ifPresent(tile -> {
                BlockPos pos = this.getConsole().getLandTime() <= 0 ? this.getConsole().getCurrentLocation().func_177967_a(this.getConsole().getExteriorFacingDirection(), 3) : this.getConsole().getPositionInFlight().getPos().func_177967_a(this.getConsole().getExteriorFacingDirection(), 3);
                tile.setCurrentLocation(this.getConsole().getCurrentDimension(), pos);
            });
        } else if (this.slave.isPresent()) {
            this.unlink();
        }
    }

    @Override
    public void onTakeoff() {
        if (this.isUsable() && this.isActivated()) {
            if (!this.slave.isPresent()) {
                this.findSlave();
            }
            this.slave.ifPresent(tile -> {
                tile.takeoffTowed();
                this.getConsole().getControl(LandingTypeControl.class).ifPresent(parent -> tile.getControl(LandingTypeControl.class).ifPresent(landType -> landType.setLandType(parent.getLandType())));
            });
        } else if (this.slave.isPresent()) {
            this.unlink();
        }
    }

    @Override
    public void onFlightSecond() {
        if (this.isUsable() && this.isActivated()) {
            this.slave.ifPresent(tile -> {});
        }
    }

    public Optional<ConsoleTile> getSlave() {
        return this.slave;
    }

    public void setSlave(Optional<ConsoleTile> tile) {
        this.slave = tile;
    }

    public void unlink() {
        this.slave = Optional.empty();
    }

    private void findSlave() {
        TimeLinkUpgradeItem link;
        RegistryKey<World> type;
        Item item = this.getStack().func_77973_b();
        if (item != null && item instanceof TimeLinkUpgradeItem && (type = (link = (TimeLinkUpgradeItem)item).getConsoleWorldKey(this.getStack())) != null) {
            ServerWorld world = this.getConsole().func_145831_w().func_73046_m().func_71218_a(type);
            TardisHelper.getConsoleInWorld((World)world).ifPresent(slave -> this.setSlave(Optional.of(slave)));
        }
    }
}

