/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.upgrades;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.upgrades.Upgrade;
import net.tardis.mod.upgrades.UpgradeEntry;

public class AtriumUpgrade
extends Upgrade
implements INBTSerializable<CompoundNBT> {
    private static ResourceLocation REGISTRY_NAME = new ResourceLocation("tardis", "atrium");
    public static int radius = 5;
    private Map<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
    private int width = 0;
    private int height = 0;

    public AtriumUpgrade(UpgradeEntry entry, ConsoleTile tile, @Nullable Class<? extends Subsystem> sys) {
        super(entry, tile, sys);
        tile.registerDataHandler(REGISTRY_NAME, this);
    }

    public void add(BlockPos pos, BlockState state) {
        this.blocks.put(pos, state);
    }

    public BlockState getState(BlockPos pos) {
        return this.blocks.getOrDefault(pos, Blocks.field_150350_a.func_176223_P());
    }

    public Map<BlockPos, BlockState> getStoredBlocks() {
        return this.blocks;
    }

    public boolean isActive() {
        if (this.getConsole() != null && this.getConsole().getExteriorType() == ExteriorRegistry.DISGUISE.get()) {
            return false;
        }
        return this.isUsable();
    }

    public void recalculateSize() {
        int width = 0;
        int height = 0;
        for (BlockPos pos : this.blocks.keySet()) {
            if (Math.abs(pos.func_177958_n()) > width) {
                width = Math.abs(pos.func_177958_n());
            }
            if (Math.abs(pos.func_177952_p()) > width) {
                width = Math.abs(pos.func_177952_p());
            }
            if (pos.func_177956_o() <= height) continue;
            height = pos.func_177956_o();
        }
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a("pos", entry.getKey().func_218275_a());
            nbt.func_218657_a("state", (INBT)NBTUtil.func_190009_a((BlockState)entry.getValue()));
            list.add((Object)nbt);
        }
        tag.func_218657_a("list", (INBT)list);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c("list", 10);
        for (INBT item : list) {
            CompoundNBT comp = (CompoundNBT)item;
            this.blocks.put(BlockPos.func_218283_e((long)comp.func_74763_f("pos")), NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("state")));
        }
    }

    @Override
    public void onLand() {
    }

    @Override
    public void onTakeoff() {
    }

    @Override
    public void onFlightSecond() {
    }
}

