/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.traits;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.PlayerTelepathicConnection;
import net.tardis.mod.traits.TardisTraitType;

public abstract class TardisTrait {
    public static final TranslationTextComponent DISLIKES_LOCATION = new TranslationTextComponent("trait.tardis.dislike_location");
    public static final TranslationTextComponent LIKES_LOCATION = new TranslationTextComponent("trait.tardis.like_location");
    public static final TranslationTextComponent GENERIC_LIKE = new TranslationTextComponent("trait.tardis.generic_like");
    public static final TranslationTextComponent GENERIC_DISLIKE = new TranslationTextComponent("trait.tardis.generic_dislike");
    private double weight = 1.0;
    private TardisTraitType type;

    public TardisTrait(TardisTraitType type) {
        this.type = type;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getModifier() {
        return 1.0 - this.getWeight();
    }

    public TardisTrait setWeight(double weight) {
        this.weight = weight;
        return this;
    }

    public TardisTraitType getType() {
        return this.type;
    }

    public abstract void tick(ConsoleTile var1);

    public void warnPlayer(ConsoleTile tile, TranslationTextComponent text) {
        if (!tile.func_145831_w().func_201670_d()) {
            for (PlayerTelepathicConnection connection : tile.getEmotionHandler().getConnectedPlayers().values()) {
                connection.getPlayer(tile.func_145831_w().func_73046_m()).ifPresent(player -> player.func_146105_b((ITextComponent)text, true));
            }
        }
    }

    public void warnPlayerLooped(ConsoleTile tile, TranslationTextComponent trans, int interval) {
        if (tile.func_145831_w().func_82737_E() % (long)interval == 0L) {
            this.warnPlayer(tile, trans);
        }
    }
}

