/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.traits;

import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.EmotionHandler;
import net.tardis.mod.traits.TardisTrait;
import net.tardis.mod.traits.TardisTraitType;

public class JealousTrait
extends TardisTrait {
    public JealousTrait(TardisTraitType type) {
        super(type);
    }

    @Override
    public void tick(ConsoleTile tile) {
        if (!tile.func_145831_w().func_201670_d() && tile.func_145831_w().func_82737_E() % 200L == 0L) {
            for (UUID uuid : tile.getEmotionHandler().getLoyaltyTrackingCrew()) {
                ServerPlayerEntity player = tile.func_145831_w().func_73046_m().func_184103_al().func_177451_a(uuid);
                if (player == null) continue;
                if (TardisHelper.isInATardis((PlayerEntity)player) && !player.func_71121_q().func_234923_W_().equals(tile.func_145831_w().func_234923_W_())) {
                    TardisHelper.getConsoleInWorld((World)player.func_71121_q()).ifPresent(otherTardis -> {
                        if (otherTardis.isInFlight() && tile.getEmotionHandler().getMood() > (double)EmotionHandler.EnumHappyState.SAD.getTreshold()) {
                            double mod = this.getModifier();
                            tile.getEmotionHandler().addMood(-(1 * (int)Math.round(4.0 * mod)));
                            tile.getEmotionHandler().addLoyalty(uuid, -(1 + (int)Math.round(4.0 * mod)));
                        }
                    });
                }
                if (!tile.isInFlight() || tile.getPilot() != player || !(tile.getEmotionHandler().getMood() < (double)EmotionHandler.EnumHappyState.HAPPY.getTreshold())) continue;
                tile.getEmotionHandler().addMood(10.0);
            }
        }
    }
}

