/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.traits;

import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.EmotionHandler;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.traits.TardisTrait;
import net.tardis.mod.traits.TardisTraitType;

public class ColdBloodedTrait
extends TardisTrait {
    LazyOptional<ExteriorTile> exteriorHolder;

    public ColdBloodedTrait(TardisTraitType type) {
        super(type);
    }

    @Override
    public void tick(ConsoleTile tile) {
        if (!tile.isInFlight() && tile.func_145831_w().func_82737_E() % 20L == 0L) {
            if (this.exteriorHolder == null || !this.exteriorHolder.isPresent()) {
                this.exteriorHolder = tile.getOrFindExteriorTile();
            }
            this.exteriorHolder.ifPresent(ext -> {
                Biome b = ext.func_145831_w().func_226691_t_(ext.func_174877_v());
                if ((b.func_201851_b() == Biome.RainType.SNOW || b.func_225486_c(ext.func_174877_v()) <= 0.15f) && tile.getEmotionHandler().getMood() > (double)EmotionHandler.EnumHappyState.DISCONTENT.getTreshold()) {
                    tile.getEmotionHandler().addMood(-(0.05 + this.getModifier() * 0.2));
                    this.warnPlayerLooped(tile, TardisTrait.DISLIKES_LOCATION, 400);
                }
            });
        }
    }
}

