/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.monitors;

import java.text.DecimalFormat;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.IMonitor;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.TTiles;

public class MonitorTile
extends TileEntity
implements ITickableTileEntity,
IMonitor {
    protected String[] info = new String[0];
    public double startX = 0.0;
    public double startY = 0.0;
    public double startZ = 0.0;
    public double width = 0.0;
    public double height = 0.0;
    public MonitorView view = MonitorView.NORTH_WEST;
    private ConsoleTile console;
    public static DecimalFormat format = new DecimalFormat("###");

    public MonitorTile() {
        this((TileEntityType)TTiles.STEAMPUNK_MONITOR.get());
    }

    public MonitorTile(TileEntityType<?> tile) {
        super(tile);
    }

    public void func_73660_a() {
        ConsoleTile console = this.getConsole();
        if (console == null) {
            return;
        }
        this.info = Helper.getConsoleText(console);
    }

    @Nullable
    private ConsoleTile getConsole() {
        if (this.console == null || this.console.func_145837_r()) {
            TardisHelper.getConsoleInWorld(this.field_145850_b).ifPresent(tile -> {
                this.console = tile;
            });
        }
        return this.console;
    }

    public void setGuiXYZ(double x, double y, double z, double width, double height) {
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.width = width;
        this.height = height;
    }

    public String[] getInfo() {
        return this.info;
    }

    @Override
    public MonitorView getView() {
        return this.view;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.view = MonitorView.values()[compound.func_74762_e("view")];
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("view", this.view.ordinal());
        return super.func_189515_b(compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    @Override
    public void setView(MonitorView view) {
        this.view = view;
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.markAndNotifyBlock(this.func_174877_v(), this.field_145850_b.func_175726_f(this.func_174877_v()), this.func_195044_w(), this.func_195044_w(), 3, 512);
        }
    }

    public static enum MonitorView {
        PANORAMIC,
        SOUTH_EAST,
        NORTH_WEST;

        Supplier<Float> angle;

        public void setAngle(Supplier<Float> sup) {
            this.angle = sup;
        }

        public float getAngle() {
            return this.angle.get().floatValue();
        }
    }
}

