/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.monitors;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.misc.IMonitor;
import net.tardis.mod.network.Network;
import net.tardis.mod.tileentities.TTiles;
import net.tardis.mod.tileentities.monitors.MonitorTile;

public class MonitorDynamicTile
extends TileEntity
implements IMonitor {
    public static final int MAX_WIDTH = 32;
    private MonitorTile.MonitorView view = MonitorTile.MonitorView.PANORAMIC;

    public MonitorDynamicTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public MonitorDynamicTile() {
        super((TileEntityType)TTiles.DYNAMIC_MONITOR.get());
    }

    public boolean isCorner() {
        Direction dir = ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176735_f();
        if (this.isStateVaildMonitor(this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(dir)))) {
            return false;
        }
        return !this.isStateVaildMonitor(this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a()));
    }

    public boolean isStateVaildMonitor(BlockState state) {
        return state.func_177230_c() == TBlocks.dynamic_monitor.get() && this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208157_J) && ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176740_k() == ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176740_k();
    }

    public int getWidth() {
        Direction dir = ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176746_e();
        int width = 1;
        for (int x = 1; x < 32 && this.isStateVaildMonitor(this.field_145850_b.func_180495_p(this.func_174877_v().func_177967_a(dir, x))); ++x) {
            ++width;
        }
        return width;
    }

    public int getHeight() {
        int height = this.getHeightAtPos(this.func_174877_v());
        int width = this.getWidth();
        Direction dir = ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176746_e();
        for (int x = 1; x < width; ++x) {
            int newHeight = this.getHeightAtPos(this.func_174877_v().func_177967_a(dir, x));
            if (newHeight >= height) continue;
            height = newHeight;
        }
        return height;
    }

    public int getHeightAtPos(BlockPos pos) {
        int height = 1;
        for (int i = 1; i < 32 && this.isStateVaildMonitor(this.field_145850_b.func_180495_p(pos.func_177967_a(Direction.DOWN, i))); ++i) {
            ++height;
        }
        return height;
    }

    public BlockPos getMaster() {
        int y = 0;
        for (int i = 1; i < 32 && this.isStateVaildMonitor(this.field_145850_b.func_180495_p(this.func_174877_v().func_177967_a(Direction.UP, i))); ++i) {
            ++y;
        }
        Direction dir = this.getFacing().func_176735_f();
        int x = 0;
        for (int i = 1; i < 32 && this.isStateVaildMonitor(this.field_145850_b.func_180495_p(this.func_174877_v().func_177967_a(dir, i))); ++i) {
            ++x;
        }
        return this.func_174877_v().func_177967_a(dir, x).func_177981_b(y);
    }

    public Direction getFacing() {
        return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isCorner()) {
            return super.getRenderBoundingBox();
        }
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(32.0);
    }

    @Override
    public MonitorTile.MonitorView getView() {
        return this.view;
    }

    @Override
    public void setView(MonitorTile.MonitorView view) {
        IMonitor mon = this.getMasterMonitor();
        if (mon != this) {
            mon.setView(view);
        }
        this.view = view;
        this.updateClient();
        this.func_70296_d();
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return Network.createTEUpdatePacket(this);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.view = MonitorTile.MonitorView.values()[compound.func_74762_e("view")];
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("view", this.view.ordinal());
        return super.func_189515_b(compound);
    }

    public void updateClient() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public IMonitor getMasterMonitor() {
        if (this.isCorner()) {
            return this;
        }
        BlockPos master = this.getMaster();
        if (this.field_145850_b.func_175625_s(master) instanceof IMonitor) {
            return (IMonitor)this.field_145850_b.func_175625_s(master);
        }
        return this;
    }
}

