/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.machines;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.tardis.mod.blocks.TransductionBarrierBlock;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.controls.LandingTypeControl;
import net.tardis.mod.entity.TardisDisplayEntity;
import net.tardis.mod.helper.LandingSystem;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.IAffectTARDISLanding;
import net.tardis.mod.tileentities.TTiles;
import net.tardis.mod.tileentities.console.misc.AlarmType;
import net.tardis.mod.tileentities.console.misc.MonitorOverride;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class TransductionBarrierTile
extends TileEntity
implements ITickableTileEntity,
IAffectTARDISLanding {
    private String landingCode = "";
    private EnergyStorage power = this.getEnergyCap();
    private LazyOptional<EnergyStorage> powerHolder = LazyOptional.of(() -> this.power);

    public TransductionBarrierTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TransductionBarrierTile() {
        this((TileEntityType)TTiles.TRANSDUCTION_BARRIER.get());
    }

    public void setCode(String code) {
        this.landingCode = code;
        this.func_70296_d();
    }

    public String getCode() {
        return this.landingCode;
    }

    public boolean canLand(ConsoleTile tile) {
        return this.power.getEnergyStored() >= (Integer)TConfig.SERVER.transductionDrainAmount.get() && tile.getLandingCode().toLowerCase().contentEquals(this.landingCode.toLowerCase());
    }

    public void onBlockedTARDIS(ConsoleTile tile) {
        this.power.extractEnergy(((Integer)TConfig.SERVER.transductionDrainAmount.get()).intValue(), false);
        this.func_70296_d();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.landingCode = compound.func_74779_i("landing_code");
        this.power.receiveEnergy(compound.func_74762_e("power"), false);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74778_a("landing_code", this.landingCode);
        compound.func_74768_a("power", this.power.getEnergyStored());
        return super.func_189515_b(compound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.deserializeNBT(pkt.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.powerHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.power.getEnergyStored() > 0 && this.field_145850_b.func_82737_E() + 5L == 0L && this.func_195044_w().func_235901_b_((Property)TransductionBarrierBlock.ACTIVATED) && ((Boolean)this.func_195044_w().func_177229_b((Property)TransductionBarrierBlock.ACTIVATED)).booleanValue()) {
            this.power.extractEnergy(1, false);
        }
    }

    @Override
    public SpaceTimeCoord affectTARDIS(ServerWorld world, SpaceTimeCoord currentLanding, ConsoleTile console) {
        if (!this.canLand(console)) {
            if (this.func_195044_w().func_235901_b_((Property)TransductionBarrierBlock.ACTIVATED) && ((Boolean)this.func_195044_w().func_177229_b((Property)TransductionBarrierBlock.ACTIVATED)).booleanValue()) {
                Random rand = world.field_73012_v;
                BlockPos landSpot = LandingSystem.getLand((World)world, this.field_174879_c.func_177967_a(Direction.func_176731_b((int)rand.nextInt(4)), 64), LandingTypeControl.EnumLandType.DOWN, console);
                console.getInteriorManager().soundAlarm(AlarmType.LOW);
                this.onBlockedTARDIS(console);
                ArrayList<String> list = new ArrayList<String>();
                list.add(new TranslationTextComponent("text.tardis.transduction.line1").getString());
                list.add(new TranslationTextComponent("text.tardis.transduction.line2").getString());
                list.add(new TranslationTextComponent("text.tardis.transduction.line3").getString());
                console.getInteriorManager().setMonitorOverrides(new MonitorOverride(console, 100, list));
                TardisDisplayEntity entity = new TardisDisplayEntity((World)world);
                BlockPos originalLandPos = currentLanding.getPos();
                TileEntity ext = console.getExteriorType().getDefaultState().createTileEntity((IBlockReader)world);
                if (ext != null) {
                    entity.setTile((ExteriorTile)ext);
                }
                entity.func_70107_b((double)originalLandPos.func_177958_n() + 0.5, originalLandPos.func_177956_o() + 1, (double)originalLandPos.func_177952_p() + 0.5);
                entity.func_213293_j((rand.nextDouble() - 0.5) * 0.5, rand.nextDouble() * 0.5, (rand.nextDouble() - 0.5) * 0.5);
                world.func_217376_c((Entity)entity);
                return new SpaceTimeCoord((RegistryKey<World>)world.func_234923_W_(), landSpot);
            }
            return null;
        }
        return null;
    }

    @Override
    public int getEffectiveRange() {
        return (Integer)TConfig.SERVER.transductionEffectiveRange.get();
    }

    public EnergyStorage getEnergyCap() {
        return new EnergyStorage(((Integer)TConfig.SERVER.transductionEnergyMaxCapacity.get()).intValue());
    }
}

