/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.machines;

import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.tardis.mod.blocks.RoundelTapBlock;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.ITardisWorldData;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.energy.TardisEnergy;
import net.tardis.mod.tileentities.TTiles;

public class RoundelTapTile
extends TileEntity
implements IEnergyStorage,
ITickableTileEntity {
    private IEnergyStorage energyStorage = this.getEnergyCap();
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private boolean hasSetupCaps = false;

    public RoundelTapTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public RoundelTapTile() {
        super((TileEntityType)TTiles.ROUNDEL_TAP.get());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.energyStorage != null) {
            this.releasePowerToTardis();
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.energy.invalidate();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    private IEnergyStorage getEnergyCap() {
        return new TardisEnergy(Integer.MAX_VALUE, (Integer)TConfig.SERVER.roundelTapEnergyTransferRate.get());
    }

    public EnergyStorage getTardisEnergyCap() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            ITardisWorldData cap = (ITardisWorldData)this.field_145850_b.getCapability(Capabilities.TARDIS_DATA).orElse(null);
            if (cap != null) {
                return cap.getEnergyCap();
            }
            return new EnergyStorage(0);
        }
        return new EnergyStorage(0);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d()) {
            if (!this.hasSetupCaps) {
                this.energyStorage = this.getTardisEnergyCap();
                this.hasSetupCaps = true;
            }
            this.getAndPushPower();
        }
    }

    public void releasePowerToTardis() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            this.field_145850_b.getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> cap.getEnergyCap().receiveEnergy(this.getEnergyStored(), false));
        }
    }

    public void getAndPushPower() {
        for (Direction dir : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (te == null) continue;
            te.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()).ifPresent(cap -> {
                IEnergyStorage tardisEnergyCap = this.energyStorage;
                if (this.func_195044_w().func_235901_b_((Property)RoundelTapBlock.PUSH)) {
                    if (((Boolean)this.func_195044_w().func_177229_b((Property)RoundelTapBlock.PUSH)).booleanValue()) {
                        int amountToExtract = (Integer)TConfig.SERVER.roundelTapEnergyTransferRate.get();
                        int received = tardisEnergyCap.extractEnergy(amountToExtract, false);
                        cap.receiveEnergy(received, false);
                    } else {
                        int amountToExtract = cap.extractEnergy(((Integer)TConfig.SERVER.roundelTapEnergyTransferRate.get()).intValue(), false);
                        tardisEnergyCap.receiveEnergy(amountToExtract, false);
                    }
                }
            });
        }
    }
}

