/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.machines;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.containers.QuantiscopeSonicContainer;
import net.tardis.mod.containers.QuantiscopeWeldContainer;
import net.tardis.mod.recipe.WeldRecipe;
import net.tardis.mod.recipe.WeldRecipeWrapper;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.TTiles;

public class QuantiscopeTile
extends TileEntity
implements IItemHandlerModifiable,
ITickableTileEntity {
    private ItemStackHandler handler = new ItemStackHandler(7);
    private LazyOptional<ItemStackHandler> buffer = LazyOptional.of(() -> this.handler);
    private EnumMode mode = EnumMode.WELD;
    private WeldRecipe weldRecipe;
    private int progress = 0;
    private int maxProgress = 200;

    public QuantiscopeTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public QuantiscopeTile() {
        super((TileEntityType)TTiles.QUANTISCOPE.get());
    }

    public void func_73660_a() {
        if (this.mode == EnumMode.WELD) {
            if (this.weldRecipe == null) {
                this.weldRecipe = this.getRecipe();
            }
            if (this.weldRecipe != null && this.shouldWeld()) {
                this.maxProgress = this.weldRecipe.getProcessingTicks().orElse(200);
                this.insertItem(6, new ItemStack((IItemProvider)this.weldRecipe.getResult().get().getOutput()), true);
                if (this.progress == 0 && !this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                }
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    this.finish();
                }
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    if (this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.4, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                    }
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)TSounds.ELECTRIC_SPARK.get(), SoundCategory.BLOCKS, 0.5f, 1.5f);
                    }
                }
                if (this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.4, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                }
            } else {
                this.weldRecipe = null;
                this.progress = 0;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                }
            }
        }
    }

    private boolean shouldWeld() {
        if (this.weldRecipe != null) {
            return this.doesMatrixMatchRecipe(this.weldRecipe) && this.insertItem(6, new ItemStack((IItemProvider)this.weldRecipe.getResult().get().getOutput()), true) == ItemStack.field_190927_a;
        }
        return false;
    }

    private void finish() {
        if (this.weldRecipe.isRepair()) {
            ItemStack result = this.getStackInSlot(5).func_77946_l();
            result.func_196085_b(0);
            this.setStackInSlot(6, result);
        } else {
            this.insertItem(6, new ItemStack((IItemProvider)this.weldRecipe.getResult().get().getOutput()), false);
            this.func_70296_d();
        }
        for (int i = 0; i < 6; ++i) {
            this.getStackInSlot(i).func_190918_g(1);
        }
        this.progress = 0;
        this.weldRecipe = null;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    private boolean doesMatrixMatchRecipe(WeldRecipe recipe) {
        WeldRecipeWrapper wrapper = new WeldRecipeWrapper(this);
        return recipe.matches(wrapper, this.field_145850_b);
    }

    @Nullable
    private WeldRecipe getRecipe() {
        for (WeldRecipe rec : WeldRecipe.getAllRecipes(this.field_145850_b)) {
            if (!this.doesMatrixMatchRecipe(rec)) continue;
            return rec;
        }
        return null;
    }

    public float getProgress() {
        return (float)this.progress / (float)this.maxProgress;
    }

    public int getCurrentProgress() {
        return this.progress;
    }

    public int getMaxProgressTicks() {
        return this.maxProgress;
    }

    public EnumMode getMode() {
        return this.mode;
    }

    public void setMode(EnumMode mode) {
        this.mode = mode;
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public WeldRecipe getCurrentRecipe() {
        return this.weldRecipe;
    }

    public void setCurrentRecipe(WeldRecipe recipe) {
        if (this.mode == EnumMode.WELD && recipe != null) {
            this.weldRecipe = recipe;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.mode = EnumMode.values()[compound.func_74762_e("mode")];
        this.handler.deserializeNBT(compound.func_74775_l("item_handler"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("mode", this.mode.ordinal());
        compound.func_218657_a("item_handler", (INBT)this.handler.serializeNBT());
        return super.func_189515_b(compound);
    }

    public Container createContainer(int id, PlayerInventory inv) {
        return this.mode.fact.create(id, inv, this);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        this.func_70296_d();
        return this.handler.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.func_70296_d();
        return this.handler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.handler.setStackInSlot(slot, stack);
        this.func_70296_d();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.buffer.cast() : super.getCapability(cap, side);
    }

    public static interface IQuantiscopeFactory<T extends Container> {
        public T create(int var1, PlayerInventory var2, QuantiscopeTile var3);
    }

    public static enum EnumMode {
        WELD(QuantiscopeWeldContainer::new),
        SONIC(QuantiscopeSonicContainer::new);

        IQuantiscopeFactory<Container> fact;
        int workTime = 200;

        private EnumMode(IQuantiscopeFactory<Container> fact) {
            this.fact = fact;
        }

        private EnumMode(IQuantiscopeFactory<Container> fact, int workTime) {
            this.fact = fact;
            this.workTime = workTime;
        }
    }
}

