/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.machines;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.network.Network;
import net.tardis.mod.recipe.SpectrometerRecipe;
import net.tardis.mod.recipe.TardisRecipeSerialisers;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.Schematics;
import net.tardis.mod.tileentities.TTiles;

public class NeutronicSpectrometerTile
extends TileEntity
implements ITickableTileEntity {
    public static final int INPUT_SLOT = 0;
    public static final int SONIC_SLOT = 1;
    private int progressTicks;
    private int maxTicks = 0;
    private int downloadTicks;
    private int maxDownloadTicks = 200;
    private ItemStackHandler inventory = new ItemStackHandler(2);
    private LazyOptional<ItemStackHandler> itemHolder = LazyOptional.of(() -> this.inventory);
    private List<Schematic> schematics = Lists.newArrayList();
    private SpectrometerRecipe currentRecipe;
    private RecipeWrapper recipeWrapper = new RecipeWrapper((IItemHandlerModifiable)this.inventory);

    public NeutronicSpectrometerTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public NeutronicSpectrometerTile() {
        this((TileEntityType)TTiles.SPECTROMETER.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.schematics.clear();
        this.progressTicks = compound.func_74762_e("progress_ticks");
        this.downloadTicks = compound.func_74762_e("download_ticks");
        ListNBT schematicList = compound.func_150295_c("schematics", 10);
        for (INBT base : schematicList) {
            CompoundNBT nbt = (CompoundNBT)base;
            ResourceLocation key = new ResourceLocation(nbt.func_74779_i("schematic_id"));
            Schematic schematic = Schematics.SCHEMATIC_REGISTRY.get(key);
            if (schematic == null) continue;
            this.schematics.add(schematic);
        }
        this.inventory.deserializeNBT(compound.func_74775_l("inv_handler"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("progress_ticks", this.progressTicks);
        compound.func_74768_a("download_ticks", this.downloadTicks);
        ListNBT schematicList = new ListNBT();
        for (Schematic schematic : this.schematics) {
            CompoundNBT schematicLoc = new CompoundNBT();
            schematicLoc.func_74778_a("schematic_id", schematic.getId().toString());
            schematicList.add((Object)schematicLoc);
        }
        compound.func_218657_a("schematics", (INBT)schematicList);
        compound.func_218657_a("inv_handler", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return Network.createTEUpdatePacket(this);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.deserializeNBT(tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.itemHolder.cast() : super.getCapability(cap, side);
    }

    public void func_73660_a() {
        SpectrometerRecipe newRecipe = this.getRecipe();
        if (newRecipe != null && this.currentRecipe != newRecipe) {
            this.currentRecipe = newRecipe;
        }
        if (this.currentRecipe != null && this.canAdvanceProgress(this.currentRecipe)) {
            this.maxTicks = this.currentRecipe.getTicks();
            this.maxDownloadTicks = this.currentRecipe.getDownloadTicks();
            ++this.progressTicks;
            if (this.progressTicks >= this.currentRecipe.getTicks()) {
                this.finish(this.currentRecipe);
            }
        } else {
            this.progressTicks = 0;
        }
        this.downloadToSonic();
    }

    public void downloadToSonic() {
        ItemStack sonicStack = this.inventory.getStackInSlot(1);
        if (sonicStack.func_77973_b() instanceof SonicItem && !this.schematics.isEmpty()) {
            ++this.downloadTicks;
            if (this.downloadTicks > this.maxDownloadTicks) {
                sonicStack.getCapability(Capabilities.SONIC_CAPABILITY).ifPresent(cap -> {
                    this.downloadTicks = 0;
                    for (Schematic s : this.schematics) {
                        cap.addSchematic(s);
                    }
                    this.schematics.clear();
                    this.func_70296_d();
                });
            }
        } else {
            this.downloadTicks = 0;
        }
    }

    public boolean canAdvanceProgress(SpectrometerRecipe rec) {
        return rec.matches(this.recipeWrapper, this.field_145850_b);
    }

    public void finish(SpectrometerRecipe recipe) {
        this.inventory.extractItem(0, 1, false);
        this.schematics.add(recipe.getSchematicObject());
        this.func_70296_d();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nullable
    public SpectrometerRecipe getRecipe() {
        for (SpectrometerRecipe rec : this.field_145850_b.func_199532_z().func_241447_a_(TardisRecipeSerialisers.SPECTROMETER_TYPE)) {
            if (rec == null || !rec.matches(this.recipeWrapper, this.field_145850_b)) continue;
            return rec;
        }
        return null;
    }

    public float getProgress() {
        return this.maxTicks == 0 ? 0.0f : (float)this.progressTicks / (float)this.maxTicks;
    }

    public float getDownloadProgress() {
        return (float)this.downloadTicks / (float)this.maxDownloadTicks;
    }

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public int getDownloadTicks() {
        return this.downloadTicks;
    }

    public int getMaxDownloadTicks() {
        return this.maxDownloadTicks;
    }

    public List<Schematic> getSchematics() {
        return this.schematics;
    }

    public boolean hasSchematics() {
        return !this.schematics.isEmpty();
    }
}

