/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.machines;

import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.tardis.mod.artron.IArtronHolder;
import net.tardis.mod.artron.IArtronItemStackBattery;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.network.Network;
import net.tardis.mod.particles.TParticleTypes;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.TTiles;

public class ArtronCollectorTile
extends TileEntity
implements ITickableTileEntity,
IArtronHolder {
    private float artron = 0.0f;
    ItemStack stack = ItemStack.field_190927_a;
    private int particleSpawnTimer = 100;
    private boolean hasSpawnedInitialParticle = false;

    public ArtronCollectorTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public ArtronCollectorTile() {
        this((TileEntityType)TTiles.ARTRON_COLLECTOR.get());
    }

    public void func_73660_a() {
        if (this.getItem().func_190926_b()) {
            this.hasSpawnedInitialParticle = false;
        }
        if (!this.getItem().func_190926_b() && this.field_145850_b.func_201670_d()) {
            if (!this.hasSpawnedInitialParticle) {
                this.field_145850_b.func_195594_a((IParticleData)TParticleTypes.BUBBLE.get(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                this.hasSpawnedInitialParticle = true;
            }
            if (this.particleSpawnTimer > 0) {
                --this.particleSpawnTimer;
            }
            if (this.particleSpawnTimer == 7) {
                this.field_145850_b.func_195594_a((IParticleData)TParticleTypes.BUBBLE.get(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                this.resetParticleSpawnTimer();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.getItem().func_77973_b() instanceof IArtronItemStackBattery && this.field_145850_b.func_82737_E() % 20L == 0L) {
            float amountToTake = ((Float)TConfig.SERVER.artronCollectorBatteryChargeRate.get()).floatValue();
            float amountTaken = this.takeArtron(amountToTake);
            ((IArtronItemStackBattery)this.getItem().func_77973_b()).charge(this.getItem(), amountTaken);
            this.func_70296_d();
            if (this.field_145850_b.func_82737_E() % 60L == 0L) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)TSounds.ELECTRIC_ARC.get(), SoundCategory.BLOCKS, 0.05f, 1.0f);
            }
        }
    }

    public float getArtron() {
        return this.artron;
    }

    @Override
    public float recieveArtron(float amount) {
        this.artron += amount;
        return amount;
    }

    @Override
    public float takeArtron(float amt) {
        if (this.artron >= amt) {
            this.artron -= amt;
            return amt;
        }
        float oldArtron = this.artron;
        this.artron = 0.0f;
        return oldArtron;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.deserializeNBT(pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("item")) {
            this.stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("item"));
        }
        this.artron = compound.func_74760_g("artron");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("item", (INBT)this.stack.serializeNBT());
        compound.func_74776_a("artron", this.artron);
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return Network.createTEUpdatePacket(this);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public void update() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public void placeItem(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public void resetParticleSpawnTimer() {
        this.particleSpawnTimer = 100;
    }
}

