/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.machines;

import java.util.Random;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.blocks.XionCrystalBlock;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.IRift;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.particles.TParticleTypes;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.TTiles;
import net.tardis.mod.tileentities.machines.ArtronCollectorTile;

public class ArtronCollectorPylonTile
extends TileEntity
implements ITickableTileEntity {
    private ArtronCollectorTile mainUnit;
    private BlockPos crystalPos = BlockPos.field_177992_a;

    public ArtronCollectorPylonTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public ArtronCollectorPylonTile() {
        super((TileEntityType)TTiles.ARTRON_PYLON.get());
    }

    public void func_73660_a() {
        if (this.getOrFindMainUnit() != null) {
            this.spawnPylonParticles();
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && !BlockPos.field_177992_a.equals((Object)this.crystalPos)) {
            this.spawnXionGrowthParticles();
        }
        if (this.field_145850_b.func_82737_E() % 200L == 0L) {
            if (BlockPos.field_177992_a.equals((Object)this.crystalPos) || this.field_145850_b.func_180495_p(this.crystalPos).func_177230_c() != TBlocks.xion_crystal.get()) {
                this.findNearbyCrystal();
            } else if (this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                IRift rift2 = (IRift)this.field_145850_b.func_175726_f(this.func_174877_v()).getCapability(Capabilities.RIFT).orElse(null);
                if (rift2 != null && rift2.getRiftEnergy() > 20.0f) {
                    rift2.takeArtron(20.0f);
                    this.spawnXionGrowthParticles();
                    XionCrystalBlock.grow(this.field_145850_b, this.crystalPos);
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_232750_iS_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return;
            }
        }
        if (!this.field_145850_b.func_201670_d() && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.field_145850_b.func_175726_f(this.func_174877_v()).getCapability(Capabilities.RIFT).ifPresent(rift -> {
                if (rift.isRift() && this.mainUnit != null) {
                    float amountToDrain = ((Float)TConfig.SERVER.artronPylonRiftDrainRate.get()).floatValue();
                    rift.takeArtron(amountToDrain);
                    this.mainUnit.recieveArtron(amountToDrain);
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)TSounds.ELECTRIC_SPARK.get(), SoundCategory.BLOCKS, 0.3f, 1.0f);
                    this.field_145850_b.func_180501_a(this.field_174879_c, this.func_195044_w(), 3);
                }
            });
        }
    }

    public static Vector3d getPylonPartPos(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
    }

    public ArtronCollectorTile getOrFindMainUnit() {
        if (this.mainUnit != null && !this.mainUnit.func_145837_r()) {
            return this.mainUnit;
        }
        BlockPos radius = new BlockPos(16, 16, 16);
        ObjectWrapper<Object> mainUnitHolder = new ObjectWrapper<Object>(null);
        BlockPos.func_218278_a((BlockPos)this.func_174877_v().func_177973_b((Vector3i)radius), (BlockPos)this.func_174877_v().func_177971_a((Vector3i)radius)).forEach(pos -> {
            TileEntity te;
            if (pos.func_218141_a((Vector3i)this.func_174877_v(), 16.0) && (te = this.field_145850_b.func_175625_s(pos)) instanceof ArtronCollectorTile) {
                mainUnitHolder.setValue(((ArtronCollectorTile)te));
            }
        });
        this.mainUnit = mainUnitHolder.getValue();
        return this.mainUnit;
    }

    public BlockPos findNearbyCrystal() {
        if (this.crystalPos != BlockPos.field_177992_a && this.field_145850_b.func_180495_p(this.crystalPos).func_177230_c() == TBlocks.xion_crystal.get()) {
            return this.crystalPos;
        }
        BlockPos radius = new BlockPos(16, 16, 16);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.func_174877_v().func_177973_b((Vector3i)radius), (BlockPos)this.func_174877_v().func_177971_a((Vector3i)radius))) {
            if (this.func_145831_w().func_180495_p(pos).func_177230_c() != TBlocks.xion_crystal.get()) continue;
            this.crystalPos = pos.func_185334_h();
            return this.crystalPos;
        }
        return BlockPos.field_177992_a;
    }

    private void spawnPylonParticles() {
        Vector3d start = ArtronCollectorPylonTile.getPylonPartPos(this.mainUnit.func_174877_v());
        Vector3d end = WorldHelper.vecFromPos((Vector3i)this.func_174877_v());
        Vector3d path = start.func_178788_d(end);
        Vector3d speed = path.func_72432_b().func_186678_a(0.05);
        for (int i = 0; i < 10; ++i) {
            double percent = (double)i / 10.0;
            this.field_145850_b.func_195594_a((IParticleData)TParticleTypes.ARTRON.get(), (double)this.field_174879_c.func_177958_n() + 0.5 + path.func_82615_a() * percent, (double)this.field_174879_c.func_177956_o() + 1.3 + path.func_82617_b() * percent, (double)this.field_174879_c.func_177952_p() + 0.5 + path.field_72449_c * percent, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        }
        Random rand = this.field_145850_b.func_201674_k();
        for (int i = 0; i < 5; ++i) {
            Vector3d part = new Vector3d(1.5 - rand.nextDouble() * 3.0, 1.5 - rand.nextDouble() * 3.0, 1.5 - rand.nextDouble() * 3.0);
            Vector3d partSpeed = part.func_178788_d(new Vector3d(0.5, 0.5, 0.5)).func_72432_b().func_186678_a(-0.05);
            this.field_145850_b.func_195594_a((IParticleData)TParticleTypes.ARTRON.get(), (double)this.field_174879_c.func_177958_n() + 0.5 + part.func_82615_a(), (double)this.field_174879_c.func_177956_o() + 0.5 + part.func_82617_b(), (double)this.field_174879_c.func_177952_p() + 0.5 + part.func_82616_c(), partSpeed.field_72450_a, partSpeed.field_72448_b, partSpeed.field_72449_c);
        }
    }

    private void spawnXionGrowthParticles() {
        Vector3d start = ArtronCollectorPylonTile.getPylonPartPos(this.crystalPos);
        Vector3d end = WorldHelper.vecFromPos((Vector3i)this.func_174877_v());
        Vector3d path = start.func_178788_d(end);
        Vector3d speed = path.func_72432_b().func_186678_a(0.05);
        for (int i = 0; i < 10; ++i) {
            double percent = (double)i / 10.0;
            this.field_145850_b.func_195594_a((IParticleData)TParticleTypes.ARTRON.get(), (double)this.field_174879_c.func_177958_n() + 0.5 + path.func_82615_a() * percent, (double)this.field_174879_c.func_177956_o() + 0.2 + path.func_82617_b() * percent, (double)this.field_174879_c.func_177952_p() + 0.5 + path.field_72449_c * percent, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        }
        Random rand = this.field_145850_b.func_201674_k();
        for (int i = 0; i < 20; ++i) {
            Vector3d part = new Vector3d(1.5 - rand.nextDouble() * 3.0, 1.5 - rand.nextDouble() * 3.0, 1.5 - rand.nextDouble() * 3.0);
            Vector3d partSpeed = part.func_178788_d(new Vector3d(0.5, 0.5, 0.5)).func_72432_b().func_186678_a(-0.05);
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_218420_D, (double)this.crystalPos.func_177958_n() + rand.nextDouble(), (double)this.crystalPos.func_177956_o() + 0.1 + rand.nextDouble() * 0.25, (double)this.crystalPos.func_177952_p() + rand.nextDouble(), partSpeed.field_72450_a, partSpeed.field_72448_b, partSpeed.field_72449_c);
        }
    }
}

