/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.machines;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.recipe.AlembicRecipe;
import net.tardis.mod.tileentities.TTiles;

public class AlembicTile
extends TileEntity
implements ITickableTileEntity {
    public static final int MAX_WATER = 1000;
    public static final int MAX_NON_WATER = 1000;
    private ItemStackHandler handler = new ItemStackHandler(6);
    private FluidTank waterTank = new FluidTank(1000, stack -> stack.getFluid() == Fluids.field_204546_a);
    private int progress = 0;
    private int maxProgress = 200;
    private int burnTime = 0;
    private int maxBurnTime = 1;
    private int nonWaterFluidAmount = 0;
    private int maxNonWaterFluidCapacity = 1000;
    private AlembicRecipe recipe;
    private AlembicRecipe fluidCollectionRecipe;
    private int fluidCollectionProgress = 0;
    private int fluidCollectionMaxProgress = 200;

    public AlembicTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public AlembicTile() {
        super((TileEntityType)TTiles.ALEMBIC.get());
    }

    public void func_73660_a() {
        if (this.burnTime > 0) {
            AlembicRecipe newRecipe = this.getRecipe();
            if (newRecipe != this.recipe && newRecipe != null && newRecipe.getResultType() != AlembicRecipe.ResultType.FLUID_COLLECTION) {
                this.recipe = newRecipe;
                this.progress = 0;
            }
            if (this.shouldAdvanceProgress()) {
                --this.burnTime;
                ++this.progress;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(true)), 2);
                this.maxProgress = this.recipe.getRequiredProgressTicks();
                if (this.progress >= this.maxProgress) {
                    this.handleCraftComplete();
                }
            } else {
                this.progress = 0;
            }
        }
        this.handleFuelSlot();
        this.handleWaterSlots();
        this.handleFluidCollectionBottleSlots();
    }

    private void handleFuelSlot() {
        int fuelBurnTime = ForgeHooks.getBurnTime((ItemStack)this.handler.getStackInSlot(3), null);
        if (this.burnTime <= 0 && fuelBurnTime > 0 && !this.handler.getStackInSlot(2).func_190926_b()) {
            this.burnTime = this.maxBurnTime = fuelBurnTime;
            this.handler.extractItem(3, 1, false);
            this.func_70296_d();
        }
    }

    private void handleWaterSlots() {
        this.handler.getStackInSlot(0).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(cap -> {
            FluidStack drainResult;
            if (cap.getFluidInTank(0).getFluid().func_207185_a((ITag)FluidTags.field_206959_a) && !(drainResult = cap.drain(new FluidStack((Fluid)Fluids.field_204546_a, this.waterTank.getSpace()), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                this.waterTank.fill(drainResult, IFluidHandler.FluidAction.EXECUTE);
                this.handler.insertItem(1, cap.getContainer().func_77946_l(), false);
                this.handler.getStackInSlot(0).func_190918_g(1);
                this.func_70296_d();
            }
        });
    }

    private void handleFluidCollectionBottleSlots() {
        ItemStack fluidCollectionStack = this.handler.getStackInSlot(4);
        if (!fluidCollectionStack.func_190926_b() && this.handler.getStackInSlot(5).func_190926_b()) {
            AlembicRecipe newRecipe = this.getRecipe();
            if (newRecipe != this.fluidCollectionRecipe && newRecipe != null && newRecipe.getResultType() == AlembicRecipe.ResultType.FLUID_COLLECTION) {
                this.fluidCollectionRecipe = newRecipe;
            }
            if (this.fluidCollectionRecipe != null && this.fluidCollectionRecipe.getResultType() == AlembicRecipe.ResultType.FLUID_COLLECTION) {
                this.fluidCollectionMaxProgress = this.fluidCollectionRecipe.getRequiredProgressTicks();
                ++this.fluidCollectionProgress;
                if (this.fluidCollectionProgress >= this.fluidCollectionMaxProgress) {
                    this.fluidCollectionProgress = 0;
                    if (this.fluidCollectionRecipe.getFluidCollectionIngredient().test(fluidCollectionStack) && this.nonWaterFluidAmount >= this.fluidCollectionRecipe.getRequiredNonWaterFluidAmount() && !this.fluidCollectionRecipe.getResult().func_190926_b() && this.nonWaterFluidAmount >= this.fluidCollectionRecipe.getRequiredNonWaterFluidAmount() && this.handler.insertItem(5, this.fluidCollectionRecipe.getResult(), false).func_190926_b()) {
                        this.handler.getStackInSlot(4).func_190918_g(this.fluidCollectionRecipe.getRequiredIngredientCount());
                        this.nonWaterFluidAmount -= this.fluidCollectionRecipe.getRequiredNonWaterFluidAmount();
                        this.fluidCollectionRecipe = null;
                    }
                }
                this.func_70296_d();
            }
        }
    }

    private void handleCraftComplete() {
        this.progress = 0;
        this.handler.getStackInSlot(2).func_190918_g(this.recipe.getRequiredIngredientCount());
        this.waterTank.drain(this.recipe.getRequiredWater(), IFluidHandler.FluidAction.EXECUTE);
        this.recipe.onCraft(this);
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187621_J, SoundCategory.AMBIENT, 0.25f, 1.0f);
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(false)), 2);
        this.func_70296_d();
    }

    @Nullable
    private AlembicRecipe getRecipe() {
        for (AlembicRecipe rec : AlembicRecipe.getAllRecipes(this.field_145850_b)) {
            if (!rec.matches(this)) continue;
            return rec;
        }
        return null;
    }

    public boolean shouldAdvanceProgress() {
        if (this.recipe == null) {
            return false;
        }
        if (this.recipe.getResultType() == AlembicRecipe.ResultType.FLUID_COLLECTION) {
            return false;
        }
        if (this.recipe.getResultType() == AlembicRecipe.ResultType.FLUID && this.nonWaterFluidAmount >= this.maxNonWaterFluidCapacity) {
            return false;
        }
        if (!this.handler.insertItem(5, this.recipe.func_77571_b(), true).func_190926_b()) {
            return false;
        }
        return this.recipe.matches(this);
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    public float getWaterPercentage() {
        return (float)this.waterTank.getFluidAmount() / (float)this.waterTank.getCapacity();
    }

    public int getNonWaterFluidAmount() {
        return this.nonWaterFluidAmount;
    }

    public void setNonWaterFluidAmount(int fluidAmount) {
        this.nonWaterFluidAmount = MathHelper.func_76125_a((int)fluidAmount, (int)0, (int)this.maxNonWaterFluidCapacity);
    }

    public int getMaxNonWaterFluidCapacity() {
        return this.maxNonWaterFluidCapacity;
    }

    public float getNonWaterPercentage() {
        return (float)this.nonWaterFluidAmount / (float)this.maxNonWaterFluidCapacity;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public float getBurnTimePercent() {
        return (float)this.burnTime / (float)this.maxBurnTime;
    }

    public float getProgressPercent() {
        return (float)this.progress / (float)this.maxProgress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.burnTime = compound.func_74762_e("burn_time");
        this.maxBurnTime = compound.func_74762_e("max_burn_time");
        this.progress = compound.func_74762_e("progress");
        this.nonWaterFluidAmount = compound.func_74762_e("mercury");
        this.waterTank.readFromNBT(compound.func_74775_l("water_tank"));
        this.handler.deserializeNBT(compound.func_74775_l("inv_handler"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("burn_time", this.burnTime);
        compound.func_74768_a("max_burn_time", this.maxBurnTime);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("mercury", this.nonWaterFluidAmount);
        compound.func_218657_a("water_tank", (INBT)this.waterTank.writeToNBT(new CompoundNBT()));
        compound.func_218657_a("inv_handler", (INBT)this.handler.serializeNBT());
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.deserializeNBT(tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public ItemStackHandler getItemStackHandler() {
        return this.handler;
    }
}

