/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class PanelInventory
implements IItemHandlerModifiable,
INBTSerializable<ListNBT> {
    private ItemStackHandler handler;
    private Direction dir;

    public PanelInventory(Direction dir) {
        this(dir, 9);
    }

    public PanelInventory(Direction dir, int size) {
        this.dir = dir;
        this.handler = new ItemStackHandler(size);
    }

    public ItemStack getStackInSlot(int index) {
        return index < this.handler.getSlots() ? this.handler.getStackInSlot(index) : ItemStack.field_190927_a;
    }

    public ListNBT serializeNBT() {
        ListNBT tag = new ListNBT();
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            tag.add((Object)stack.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(ListNBT nbt) {
        int index = 0;
        for (INBT tag : nbt) {
            this.handler.setStackInSlot(index, ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)tag)));
            ++index;
        }
    }

    public Direction getPanelDirection() {
        return this.dir;
    }

    public ITextComponent getName() {
        return new TranslationTextComponent("container.tardis.engine." + this.dir.func_176742_j().toLowerCase());
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.handler.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.handler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.handler.setStackInSlot(slot, stack);
    }

    public ItemStackHandler getHandler() {
        return this.handler;
    }
}

