/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.exteriors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.blocks.exteriors.ExteriorBlock;
import net.tardis.mod.boti.BotiHandler;
import net.tardis.mod.boti.IBotiEnabled;
import net.tardis.mod.boti.WorldShell;
import net.tardis.mod.boti.stores.EntityStorage;
import net.tardis.mod.boti.stores.TileStore;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.animation.ExteriorAnimationEntry;
import net.tardis.mod.client.animation.IExteriorAnimation;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.energy.TardisEnergy;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.TardisEntity;
import net.tardis.mod.entity.ai.FollowIntoTardisGoal;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.enums.EnumMatterState;
import net.tardis.mod.events.LivingEvents;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.LandingSystem;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.TexVariant;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.BOTIEntityMessage;
import net.tardis.mod.network.packets.BOTIMessage;
import net.tardis.mod.network.packets.BOTITileMessage;
import net.tardis.mod.network.packets.ExteriorDataMessage;
import net.tardis.mod.network.packets.MaterializationMessage;
import net.tardis.mod.network.packets.RequestTileDataMessage;
import net.tardis.mod.network.packets.exterior.CrashedData;
import net.tardis.mod.network.packets.exterior.DoorData;
import net.tardis.mod.network.packets.exterior.ExteriorData;
import net.tardis.mod.network.packets.exterior.InteriorRegenData;
import net.tardis.mod.network.packets.exterior.LightData;
import net.tardis.mod.network.packets.exterior.NameData;
import net.tardis.mod.network.packets.exterior.VariantData;
import net.tardis.mod.registries.ExteriorAnimationRegistry;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.ShieldGeneratorSubsystem;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.exteriors.DisguiseExteriorTile;

public abstract class ExteriorTile
extends TileEntity
implements ITickableTileEntity,
IBotiEnabled,
IEnergyStorage {
    public static final AxisAlignedBB DEFAULT_DOOR_EAST = new AxisAlignedBB(0.5, -1.0, 0.0, 1.1, 1.0, 1.0);
    public static final AxisAlignedBB DEFAULT_DOOR_SOUTH = new AxisAlignedBB(0.0, -1.0, 0.5, 1.0, 1.0, 1.1);
    public static final AxisAlignedBB DEFAULT_DOOR_WEST = new AxisAlignedBB(-0.1, -1.0, 0.0, 0.5, 1.0, 1.0);
    public static final AxisAlignedBB DEFAULT_DOOR_NORTH = new AxisAlignedBB(0.0, -1.0, -0.1, 1.0, 1.0, 0.5);
    private boolean locked = false;
    private EnumDoorState openState = EnumDoorState.CLOSED;
    private EnumDoorState[] validDoorStates = new EnumDoorState[]{EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH};
    protected RegistryKey<World> interiorDimension;
    private EnumMatterState matterState = EnumMatterState.SOLID;
    private List<UUID> teleportedIDs = new ArrayList<UUID>();
    private String customName = "";
    private IExteriorAnimation animation;
    private WorldShell shell;
    private boolean crashed = false;
    private boolean antiGravs = false;
    private boolean hasDemated = false;
    private int consoleInFlightTicks = 0;
    private int materializeTime = 0;
    private int maxMaterializeTime = 0;
    private AbstractExterior exterior = (AbstractExterior)ExteriorRegistry.STEAMPUNK.get();
    private BotiHandler botiHandler;
    private List<TexVariant> variants = new ArrayList<TexVariant>();
    private int variantIndex = 0;
    public float lightLevel = 1.0f;
    private ItemStackHandler buffer = new ItemStackHandler(0);
    private TardisEnergy energy = new TardisEnergy(0);
    private LazyOptional<ItemStackHandler> itemBuffer = LazyOptional.of(() -> this.buffer);
    private LazyOptional<TardisEnergy> energyBuffer = LazyOptional.of(() -> this.energy);
    private boolean hasSetupCaps = false;
    public final int minimumLocklevel = 0;
    private int additionalLockLevel = 0;
    private boolean isInteriorRegenerating = false;

    public ExteriorTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.animation = ((ExteriorAnimationEntry)ExteriorAnimationRegistry.EXTERIOR_ANIMATION_REGISTRY.get().getValue(new ResourceLocation("tardis", "classic"))).create(this);
        this.botiHandler = new BotiHandler(this);
        this.botiHandler.setDiameter(20);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.locked = compound.func_74767_n("locked");
        this.openState = EnumDoorState.valueOf(compound.func_74779_i("state"));
        if (compound.func_74764_b("interior")) {
            this.interiorDimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("interior")));
        }
        this.matterState = compound.func_74764_b("matter_state") ? EnumMatterState.values()[compound.func_74762_e("matter_state")] : EnumMatterState.SOLID;
        this.lightLevel = compound.func_74760_g("light_level");
        this.customName = compound.func_74779_i("custom_name");
        this.animation = ((ExteriorAnimationEntry)ExteriorAnimationRegistry.EXTERIOR_ANIMATION_REGISTRY.get().getValue(new ResourceLocation(compound.func_74779_i("animation")))).create(this);
        this.variantIndex = compound.func_74762_e("variant_index");
        this.antiGravs = compound.func_74767_n("anti_grav");
        this.hasDemated = compound.func_74767_n("has_demated");
        this.antiGravs = compound.func_74767_n("anti_grav");
        this.crashed = compound.func_74767_n("crashed");
        if (compound.func_74764_b("exterior_type")) {
            this.exterior = ExteriorRegistry.getExterior(new ResourceLocation(compound.func_74779_i("exterior_type")));
        }
        this.additionalLockLevel = compound.func_74762_e("additional_lock_level");
        this.isInteriorRegenerating = compound.func_74767_n("is_regenerating_interior");
        this.materializeTime = compound.func_74762_e("materialize_time");
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("locked", this.locked);
        compound.func_74778_a("state", this.openState.name());
        if (this.interiorDimension != null) {
            compound.func_74778_a("interior", this.interiorDimension.func_240901_a_().toString());
        }
        compound.func_74768_a("matter_state", this.matterState.ordinal());
        compound.func_74776_a("light_level", this.lightLevel);
        compound.func_74778_a("custom_name", this.customName);
        compound.func_74778_a("animation", this.animation.getType().getRegistryName().toString());
        compound.func_74768_a("variant_index", this.variantIndex);
        compound.func_74757_a("anti_grav", this.antiGravs);
        compound.func_74757_a("has_demated", this.hasDemated);
        compound.func_74757_a("anti_grav", this.antiGravs);
        compound.func_74757_a("crashed", this.crashed);
        if (this.exterior != null) {
            compound.func_74778_a("exterior_type", this.exterior.getRegistryName().toString());
        }
        compound.func_74768_a("additional_lock_level", this.additionalLockLevel);
        compound.func_74757_a("is_regenerating_interior", this.isInteriorRegenerating);
        compound.func_74768_a("materialize_time", this.materializeTime);
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = this.serializeNBT();
        tag.func_74768_a("door_state", this.openState.ordinal());
        if (this.animation != null) {
            tag.func_218657_a("anim_data", this.animation.serializeNBT());
        }
        return tag;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.deserializeNBT(pkt.func_148857_g());
        if (this.animation != null) {
            IntNBT data = (IntNBT)pkt.func_148857_g().func_74781_a("anim_data");
            this.animation.deserializeNBT((INBT)data);
        }
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemBuffer.cast();
        }
        return cap == CapabilityEnergy.ENERGY ? this.energyBuffer.cast() : super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            Network.sendToServer(new RequestTileDataMessage(Network.BOTI_REQUESTOR, this.func_174877_v()));
            Network.sendToServer(new RequestTileDataMessage(Network.MATERIALIZARION_REQUESTOR, this.func_174877_v()));
        }
    }

    public void func_73660_a() {
        double z;
        this.transferEntities(this.field_145850_b.func_217357_a(Entity.class, this.getDoorAABB().func_186670_a(this.func_174877_v())));
        this.handleMaterializationAnimations();
        if (this.matterState != EnumMatterState.SOLID) {
            this.animation.tick(this.materializeTime);
            if (!this.field_145850_b.field_72995_K) {
                for (Entity ent : this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177977_b()).func_72321_a(0.0, 1.0, 0.0))) {
                    ServerWorld serverWorld = this.field_145850_b.func_73046_m().func_71218_a(this.interiorDimension);
                    if (serverWorld == null) continue;
                    BlockPos pos = TardisHelper.TARDIS_POS.func_177970_e(4);
                    WorldHelper.teleportEntities(ent, serverWorld, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ent.field_70177_z, ent.field_70125_A);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.matterState == EnumMatterState.SOLID && this.field_145850_b.func_82737_E() % 90L == 0L) {
            TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.interiorDimension).ifPresent(tile -> tile.setCurrentLocation((RegistryKey<World>)this.field_145850_b.func_234923_W_(), this.func_174877_v().func_177977_b()));
        }
        boolean fall = LandingSystem.shouldTARDISFall(this.field_145850_b, this.field_174879_c.func_177979_c(2));
        if (!this.field_145850_b.field_72995_K && fall && !this.antiGravs && !(this instanceof DisguiseExteriorTile)) {
            this.fall();
        }
        this.pushPower();
        if (this.field_145850_b.field_72995_K) {
            double x = (double)this.func_174877_v().func_177958_n() + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5);
            double y = this.func_174877_v().func_177956_o() + 1;
            z = (double)this.func_174877_v().func_177952_p() + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5);
            if (this.crashed) {
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197594_E, x, y, z, 0.0, 0.1, 0.0);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
                }
                if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197595_F, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.isInteriorRegenerating) {
            if (this.field_145850_b.func_201670_d()) {
                double x = (double)this.func_174877_v().func_177958_n() + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5);
                double y = this.func_174877_v().func_177956_o() + 1;
                z = (double)this.func_174877_v().func_177952_p() + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5);
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197594_E, x, y, z, 0.0, 0.1, 0.0);
                }
            }
            if (!this.field_145850_b.func_201670_d() && this.field_145850_b.func_82737_E() % 200L == 0L) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)TSounds.STEAM_HISS.get(), SoundCategory.BLOCKS, 0.1f, 1.0f);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.interiorDimension == null) {
                ++this.consoleInFlightTicks;
            } else {
                TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.interiorDimension).ifPresent(tile -> {
                    if (tile.isInFlight() && tile.getLandTime() <= 0 && this.matterState == EnumMatterState.SOLID) {
                        ++this.consoleInFlightTicks;
                    }
                });
            }
            if (this.consoleInFlightTicks > 40) {
                this.deleteExteriorBlocks();
            }
            if (!this.hasSetupCaps && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(0, () -> this.field_145850_b.func_73046_m().func_71218_a(this.interiorDimension).getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                    this.buffer = data.getItemBuffer();
                    this.energy = data.getEnergyCap();
                })));
                this.hasSetupCaps = true;
            }
        }
        if (!(this.field_145850_b.func_201670_d() || this.shell != null && this.field_145850_b.func_82737_E() % 100L != 0L)) {
            this.updateOrBuildBoti();
        }
        if (this.shell != null) {
            this.shell.tick(this.field_145850_b.field_72995_K);
        }
    }

    public void placeExteriorBlocks() {
    }

    public void handleMaterializationAnimations() {
        if (this.getMatterState() != EnumMatterState.SOLID) {
            --this.materializeTime;
            if (this.materializeTime <= 0) {
                if (this.getMatterState() == EnumMatterState.DEMAT) {
                    this.deleteExteriorBlocks();
                } else {
                    this.setMatterState(EnumMatterState.SOLID);
                }
            }
        }
    }

    public void setMaterializeTime(int materializeTime) {
        this.setMaterializeTime(materializeTime, this.maxMaterializeTime);
    }

    public void setMaterializeTime(int materializeTime, int maxMaterializeTime) {
        this.materializeTime = materializeTime;
        this.maxMaterializeTime = maxMaterializeTime;
    }

    public int getMaterializationTicks() {
        return this.materializeTime;
    }

    public int getMaxMaterializationTicks() {
        return this.maxMaterializeTime;
    }

    public void deleteExteriorBlocks() {
        this.hasDemated = true;
        BlockPos extPos = this.func_174877_v();
        this.field_145850_b.func_175656_a(extPos, this.func_195044_w().func_204520_s().func_206886_c().func_207188_f().func_206883_i());
        this.field_145850_b.func_175656_a(extPos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
    }

    public void updateClient() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
        }
    }

    public void updateSpecific(ExteriorData data) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            Network.sendToTrackingTE(new ExteriorDataMessage(this.func_174877_v(), data), this);
        }
    }

    public void demat(int takeoffTime) {
        this.materializeTime = takeoffTime;
        this.setDoorState(EnumDoorState.CLOSED);
        this.hasDemated = true;
        this.animation.reset();
        this.animation.startAnim(EnumMatterState.DEMAT, takeoffTime);
        this.setMatterState(EnumMatterState.DEMAT);
        this.sendMaterializationPacket();
    }

    public void remat(int timeToLand) {
        this.materializeTime = timeToLand;
        this.setDoorState(EnumDoorState.CLOSED);
        this.setMatterState(EnumMatterState.REMAT);
        this.animation.reset();
        this.animation.startAnim(EnumMatterState.REMAT, timeToLand);
        this.sendMaterializationPacket();
    }

    public void sendMaterializationPacket() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            Network.sendToTrackingTE(new MaterializationMessage(this.func_174877_v(), this.getMatterState(), this.materializeTime, this.maxMaterializeTime), this);
        }
    }

    public boolean isKeyValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("tardis_key_linked_console") && this.interiorDimension.func_240901_a_().toString().equals(stack.func_77978_p().func_74779_i("tardis_key_linked_console"));
    }

    public void copyDoorStateToInteriorDoor() {
        TileEntity te;
        ServerWorld interior;
        if (!this.field_145850_b.field_72995_K && (interior = this.field_145850_b.func_73046_m().func_71218_a(this.interiorDimension)) != null && (te = interior.func_175625_s(TardisHelper.TARDIS_POS)) instanceof ConsoleTile) {
            WorldHelper.preLoadTardisInteriorChunks(interior, true);
            ((ConsoleTile)te).getDoor().ifPresent(door -> {
                door.setOpenState(this.getOpen());
                door.setLocked(this.locked);
                door.setAdditionalLockLevel(this.additionalLockLevel);
                door.field_70170_p.func_184133_a(null, door.func_233580_cy_(), door.getOpenState().equals((Object)EnumDoorState.CLOSED) ? (SoundEvent)TSounds.DOOR_CLOSE.get() : (SoundEvent)TSounds.DOOR_OPEN.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                door.field_70170_p.func_184133_a(null, door.func_233580_cy_(), door.isLocked() ? (SoundEvent)TSounds.DOOR_LOCK.get() : (SoundEvent)TSounds.DOOR_UNLOCK.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
            });
        }
    }

    public void transferEntities(List<Entity> entityList) {
        if (!this.field_145850_b.field_72995_K && this.getOpen() != EnumDoorState.CLOSED) {
            TileEntity te;
            if (this.interiorDimension == null) {
                return;
            }
            ArrayList<UUID> tempIDs = new ArrayList<UUID>();
            for (Entity e : entityList) {
                if (!this.teleportedIDs.contains(e.func_110124_au())) continue;
                tempIDs.add(e.func_110124_au());
            }
            this.teleportedIDs = tempIDs;
            if (entityList.isEmpty()) {
                return;
            }
            double x = 0.0;
            double y = TardisHelper.TARDIS_POS.func_177956_o();
            double z = 0.0;
            ConsoleTile console = null;
            ServerWorld ws = this.field_145850_b.func_73046_m().func_71218_a(this.interiorDimension);
            if (ws == null) {
                return;
            }
            if (ws != null && (te = ws.func_175625_s(TardisHelper.TARDIS_POS)) instanceof ConsoleTile) {
                console = (ConsoleTile)te;
            }
            DoorEntity door = console != null ? (DoorEntity)((Object)console.getDoor().orElse(null)) : null;
            float angle = 0.0f;
            if (door != null) {
                x = door.func_226277_ct_() + Math.sin(angle) * -0.8;
                z = door.func_226281_cx_() - Math.cos(angle) * -0.8;
                y = door.func_226278_cu_();
                angle = (float)Math.toRadians(door.field_70125_A);
            }
            ArrayList secondPass = Lists.newArrayList();
            for (Entity e : entityList) {
                if (e.func_184207_aI() && !e.func_184188_bt().isEmpty()) {
                    secondPass.addAll(e.func_184188_bt());
                }
                if (this.teleportedIDs.contains(e.func_110124_au()) || !e.func_70089_S() || e.func_184207_aI()) continue;
                float realRot = e.field_70177_z;
                if (door != null) {
                    float extAngle = WorldHelper.getAngleFromFacing(((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d());
                    float diff = e.field_70177_z % 360.0f - extAngle;
                    realRot = door.field_70177_z + diff;
                    door.addEntityToTeleportImmuneList(e.func_110124_au());
                }
                Vector3d oldMotion = e.func_213322_ci();
                if (e instanceof LivingEntity) {
                    MinecraftForge.EVENT_BUS.post((Event)new LivingEvents.TardisEnterEvent((LivingEntity)e, this, this.func_145831_w()));
                }
                float dist = e.func_213311_cf() / 0.75f;
                WorldHelper.teleportEntities(e, ws, x + Math.sin(angle) * (double)dist, y, z - Math.cos(angle) * (double)dist, realRot, e.field_70125_A);
                Vector3d setMot = oldMotion.func_178785_b(-((float)Math.toRadians(realRot)));
                this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                    Entity ent = ws.func_217461_a(e.func_110124_au());
                    if (ent != null) {
                        ent.func_213317_d(setMot);
                    }
                    if (ent instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)ent).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(ent));
                    }
                }));
                if (!(e instanceof PlayerEntity)) continue;
                for (MonsterEntity ent : this.field_145850_b.func_217357_a(MonsterEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(20.0))) {
                    if (ent.func_70638_az() != e) continue;
                    for (PrioritizedGoal goal : ent.field_70714_bg.field_220892_d) {
                        if (!(goal.func_220772_j() instanceof FollowIntoTardisGoal)) continue;
                        ((FollowIntoTardisGoal)goal.func_220772_j()).setTarget(this.func_174877_v());
                    }
                }
            }
            if (!secondPass.isEmpty()) {
                this.transferEntities(secondPass);
            }
        }
    }

    public void pushPower() {
        for (Direction dir : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (te == null) continue;
            te.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()).ifPresent(cap -> {
                int power = (Integer)TConfig.SERVER.exteriorEnergyTransferRate.get();
                int accepted = cap.receiveEnergy(power, false);
                this.extractEnergy(accepted, false);
            });
        }
    }

    public void addTeleportedEntity(UUID id) {
        this.teleportedIDs.add(id);
    }

    public EnumDoorState getNextDoorState() {
        int index = 0;
        for (EnumDoorState state : this.validDoorStates) {
            if (state == this.openState) {
                if (index + 1 < this.validDoorStates.length) {
                    return this.validDoorStates[index + 1];
                }
                return this.validDoorStates[0];
            }
            ++index;
        }
        return EnumDoorState.CLOSED;
    }

    public void setDoorState(EnumDoorState state) {
        EnumDoorState oldState = this.openState;
        this.openState = state;
        if (oldState != state) {
            this.func_70296_d();
        }
    }

    public EnumDoorState getOpen() {
        return this.openState;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.func_70296_d();
        this.updateClient();
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void toggleLocked() {
        boolean bl = this.locked = !this.locked;
        if (this.locked) {
            this.setDoorState(EnumDoorState.CLOSED);
            this.copyDoorStateToInteriorDoor();
        }
    }

    public void open(Entity opening) {
        if (!opening.func_130014_f_().func_201670_d()) {
            if (this.locked && !this.isExteriorDeadLocked() && !this.isInteriorRegenerating()) {
                if (opening instanceof PlayerEntity) {
                    ((PlayerEntity)opening).func_146105_b((ITextComponent)ExteriorBlock.LOCKED, true);
                }
                return;
            }
            if (this.isExteriorDeadLocked()) {
                if (opening instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)opening;
                    if (this.isInteriorRegenerating()) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(ExteriorBlock.INTERIOR_CHANGE, new Object[]{this.getRemainingInteriorChangeTime()}), true);
                    } else {
                        player.func_146105_b((ITextComponent)ExteriorBlock.DEADLOCKED, true);
                    }
                }
                this.copyDoorStateToInteriorDoor();
                return;
            }
            this.setDoorState(this.getNextDoorState());
            this.copyDoorStateToInteriorDoor();
            this.updateSpecific(DoorData.create(this));
            if (this.getOpen().equals((Object)EnumDoorState.CLOSED)) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), this.exterior.getDoorSounds().getClosedSound(), SoundCategory.BLOCKS, 0.5f, 1.0f);
            } else {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), this.exterior.getDoorSounds().getOpenSound(), SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
        }
    }

    public int getAdditionalLockLevel() {
        return this.additionalLockLevel;
    }

    public void setAdditionalLockLevel(int additionalLockLevel) {
        this.additionalLockLevel = additionalLockLevel;
        this.func_70296_d();
    }

    public boolean isExteriorDeadLocked() {
        return this.additionalLockLevel > 0;
    }

    public void setInteriorDimensionKey(World world) {
        this.interiorDimension = world.func_234923_W_();
        this.func_70296_d();
    }

    public RegistryKey<World> getInteriorDimensionKey() {
        return this.interiorDimension;
    }

    public EnumMatterState getMatterState() {
        return this.matterState;
    }

    public void setMatterState(EnumMatterState state) {
        this.matterState = state;
        this.func_70296_d();
        if (state != EnumMatterState.SOLID) {
            this.setDoorState(EnumDoorState.CLOSED);
        }
    }

    public void setLightLevel(float percent) {
        this.lightLevel = (float)MathHelper.func_151237_a((double)((double)percent + 0.2), (double)0.0, (double)1.0);
        this.func_70296_d();
        this.updateSpecific(new LightData(this.lightLevel));
    }

    public float getLightLevel() {
        return this.lightLevel;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String name) {
        this.customName = name;
        this.func_70296_d();
        this.updateSpecific(new NameData(name));
        if (!this.field_145850_b.field_72995_K) {
            TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.interiorDimension).ifPresent(tile -> tile.setCustomName(name));
        }
    }

    @Nullable
    public TardisEntity fall() {
        if (this.hasDemated) {
            return null;
        }
        if (this.matterState != EnumMatterState.REMAT) {
            TardisEntity ent = this.createEntity();
            if (ent != null) {
                ent.setExteriorTile(this);
                if (this.field_145850_b.func_217376_c((Entity)ent)) {
                    this.hasDemated = true;
                    this.deleteExteriorBlocks();
                    TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.interiorDimension).ifPresent(tile -> tile.setEntity(ent));
                }
            }
            return ent;
        }
        return null;
    }

    public void updateConsoleName() {
        if (!this.field_145850_b.field_72995_K) {
            TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.interiorDimension).ifPresent(tile -> tile.setCustomName(this.getCustomName()));
        }
    }

    public IExteriorAnimation getExteriorAnimation() {
        return this.animation;
    }

    public void setExteriorAnimation(ExteriorAnimationEntry anim) {
        this.animation = anim.create(this);
        this.func_70296_d();
        this.updateClient();
    }

    public void copyConsoleData(ConsoleTile console) {
        this.interiorDimension = console.func_145831_w().func_234923_W_();
        this.locked = false;
        this.openState = EnumDoorState.CLOSED;
        console.getDoor().ifPresent(ent -> {
            this.locked = ent.isLocked();
            this.openState = ent.getOpenState();
        });
        this.customName = console.getCustomName();
        ExteriorAnimationEntry entry = (ExteriorAnimationEntry)ExteriorAnimationRegistry.EXTERIOR_ANIMATION_REGISTRY.get().getValue(console.getExteriorManager().getExteriorAnimation());
        if (entry != null) {
            this.animation = entry.create(this);
        }
        this.lightLevel = MathHelper.func_76131_a((float)((float)console.getInteriorManager().getLight() / 15.0f + 0.2f), (float)0.0f, (float)1.0f);
        this.variantIndex = console.getExteriorManager().getExteriorVariant();
        this.antiGravs = console.getAntiGrav();
        this.exterior = console.getExteriorType();
        this.crashed = console.isCrashing();
        this.isInteriorRegenerating = console.getInteriorManager().isInteriorStillRegenerating();
        this.updateClient();
    }

    @Override
    public WorldShell getBotiWorld() {
        return this.shell;
    }

    @Override
    public void setBotiWorld(WorldShell shell) {
        this.shell = shell;
    }

    public void setVariants(TexVariant ... variants) {
        this.variants.clear();
        for (TexVariant t : variants) {
            this.variants.add(t);
        }
    }

    public void setVariant(int i) {
        this.variantIndex = i < this.variants.size() ? i : 0;
        this.func_70296_d();
        this.updateSpecific(new VariantData(this.variantIndex));
    }

    @Nullable
    public TexVariant getVariant() {
        return this.variantIndex < this.variants.size() ? this.variants.get(this.variantIndex) : null;
    }

    public abstract AxisAlignedBB getDoorAABB();

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.getEnergyBuffer().receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.getEnergyBuffer().extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.getEnergyBuffer().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getEnergyBuffer().getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.getEnergyBuffer().canExtract();
    }

    public boolean canReceive() {
        return this.getEnergyBuffer().canReceive();
    }

    public EnergyStorage getEnergyBuffer() {
        return (EnergyStorage)this.energyBuffer.orElse((Object)new TardisEnergy(Integer.MAX_VALUE, (Integer)TConfig.SERVER.exteriorEnergyTransferRate.get()));
    }

    public double func_145833_n() {
        return 16384.0;
    }

    @Nullable
    public TardisEntity createEntity() {
        if (!this.field_145850_b.field_72995_K) {
            TardisEntity entity = (TardisEntity)((EntityType)TEntities.TARDIS.get()).func_200721_a(this.field_145850_b);
            TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.interiorDimension).ifPresent(tile -> entity.setConsole((ConsoleTile)((Object)tile)));
            entity.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, this.func_174877_v().func_177956_o() - 1, (double)this.func_174877_v().func_177952_p() + 0.5);
            entity.field_70177_z = WorldHelper.getAngleFromFacing((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)) - 180.0f;
            entity.func_189654_d(this.antiGravs);
            return entity;
        }
        return null;
    }

    public void setCrashed(boolean crashed) {
        this.crashed = crashed;
        this.updateSpecific(new CrashedData(crashed));
        this.func_70296_d();
    }

    public void damage(int damage) {
        if (!this.field_145850_b.field_72995_K) {
            TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.interiorDimension).ifPresent(tile -> {
                ShieldGeneratorSubsystem sys = (ShieldGeneratorSubsystem)tile.getSubsystem(ShieldGeneratorSubsystem.class).orElse(null);
                if (sys != null && sys.canBeUsed()) {
                    sys.damage(null, damage);
                } else {
                    float realDam = (float)damage / (float)tile.getSubSystems().size();
                    for (Subsystem s : tile.getSubSystems()) {
                        s.damage(null, (int)Math.ceil(realDam));
                    }
                }
                for (PlayerEntity player : tile.func_145831_w().func_217369_A()) {
                    player.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                        cap.setShaking(60, 10.0f);
                        cap.update();
                    });
                }
                tile.func_145831_w().func_184133_a(null, tile.func_174877_v(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.75f, 0.6f);
            });
        }
    }

    public void setAntiGravs(boolean antiGravs) {
        this.antiGravs = antiGravs;
        this.func_70296_d();
    }

    public boolean getAntiGravs() {
        return this.antiGravs;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.itemBuffer.invalidate();
        this.energyBuffer.invalidate();
        if (!this.field_145850_b.field_72995_K && this.interiorDimension != null) {
            TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.interiorDimension).ifPresent(tile -> tile.getOrFindExteriorTile().invalidate());
        }
    }

    public AxisAlignedBB getDefaultEntryBox() {
        if (this.field_145850_b == null || !this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        Direction dir = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        switch (dir) {
            case EAST: {
                return DEFAULT_DOOR_EAST;
            }
            case SOUTH: {
                return DEFAULT_DOOR_SOUTH;
            }
            case WEST: {
                return DEFAULT_DOOR_WEST;
            }
        }
        return DEFAULT_DOOR_NORTH;
    }

    public WorldShell buildBoti() {
        ServerWorld interior;
        if (!this.field_145850_b.field_72995_K && (interior = this.field_145850_b.func_73046_m().func_71218_a(this.getInteriorDimensionKey())) != null) {
            TardisHelper.getConsoleInWorld((World)interior).ifPresent(arg_0 -> this.lambda$buildBoti$18((World)interior, arg_0));
            return this.shell;
        }
        return null;
    }

    public void updateOrBuildBoti() {
        this.shell = this.buildBoti();
        if (this.shell != null) {
            Network.sendToAllAround(new BOTIMessage(this.shell, this.func_174877_v()), (RegistryKey<World>)this.func_145831_w().func_234923_W_(), this.func_174877_v(), 20);
            this.field_145850_b.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                for (TileStore tileStore : this.botiHandler.getTileStores()) {
                    Network.sendToTrackingTE(new BOTITileMessage(this.func_174877_v(), tileStore), this);
                }
            }));
        }
    }

    public int getLightEmittingLevel() {
        return 3;
    }

    @Override
    public BOTIMessage createMessage(WorldShell shell) {
        return new BOTIMessage(shell, this.func_174877_v());
    }

    public boolean isInteriorRegenerating() {
        return this.isInteriorRegenerating;
    }

    public void setInteriorRegenerating(boolean isInteriorRegenerating) {
        this.isInteriorRegenerating = isInteriorRegenerating;
        this.func_70296_d();
        this.updateSpecific(new InteriorRegenData(isInteriorRegenerating));
    }

    public int getRemainingInteriorChangeTime() {
        TileEntity te;
        ServerWorld interior = this.field_145850_b.func_73046_m().func_71218_a(this.interiorDimension);
        if (interior != null && (te = interior.func_175625_s(TardisHelper.TARDIS_POS)) instanceof ConsoleTile) {
            ConsoleTile console = (ConsoleTile)te;
            return console.getInteriorManager().getInteriorProcessingTime() / 20;
        }
        return 0;
    }

    private /* synthetic */ void lambda$buildBoti$18(World interior, ConsoleTile tile) {
        tile.getDoor().ifPresent(door -> {
            BlockPos origin = door.func_233580_cy_();
            Direction portalFacingDirection = door.func_174811_aO();
            int offsetAmount = 10;
            this.botiHandler.setExcludedEntityId(door.func_145782_y());
            this.botiHandler.updateBoti(interior, origin, BlockPos.field_177992_a.func_177967_a(portalFacingDirection.func_176734_d(), offsetAmount - 2), true);
            this.getBotiWorld().setPortalDirection(portalFacingDirection);
            for (EntityStorage store : this.botiHandler.getEntityStores()) {
                Network.sendToTrackingTE(new BOTIEntityMessage(this.func_174877_v(), store), this);
            }
            for (TileStore tileStore : this.botiHandler.getTileStores()) {
                Network.sendToTrackingTE(new BOTITileMessage(this.func_174877_v(), tileStore), this);
            }
            this.botiHandler.getTileStores().clear();
        });
    }
}

