/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.exteriors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.enums.EnumMatterState;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.Disguise;
import net.tardis.mod.registries.DisguiseRegistry;
import net.tardis.mod.subsystem.ChameleonSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.TTiles;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class DisguiseExteriorTile
extends ExteriorTile {
    public Disguise disguise = (Disguise)DisguiseRegistry.STONE_PILLAR.get();
    private float particleRot = 0.0f;

    public DisguiseExteriorTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public DisguiseExteriorTile() {
        super((TileEntityType)TTiles.EXTERIOR_DISGUISE.get());
    }

    @Override
    public AxisAlignedBB getDoorAABB() {
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.func_174877_v()).func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            switch ((Direction)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((Property)BlockStateProperties.field_208157_J)) {
                case EAST: {
                    return new AxisAlignedBB(0.5, -1.0, 0.0, 1.1, 1.0, 1.0);
                }
                case SOUTH: {
                    return new AxisAlignedBB(0.0, -1.0, 0.5, 1.0, 1.0, 1.1);
                }
                case WEST: {
                    return new AxisAlignedBB(-0.1, -1.0, 0.0, 0.5, 1.0, 1.0);
                }
            }
            return new AxisAlignedBB(0.0, 0.0, -0.1, 1.0, 2.0, 0.5);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b(2.0, 5.0, 2.0);
    }

    @Override
    public void deleteExteriorBlocks() {
        super.deleteExteriorBlocks();
        this.deleteDisguiseBlocks();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("disguise")) {
            this.disguise = (Disguise)DisguiseRegistry.DISGUISE_REGISTRY.get().getValue(new ResourceLocation(compound.func_74779_i("disguise")));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.disguise != null) {
            compound.func_74778_a("disguise", this.disguise.getRegistryName().toString());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K && this.getMatterState() != EnumMatterState.SOLID) {
            int width = 1;
            int height = 2;
            if (this.disguise != null) {
                width = this.disguise.getWidth() + 1;
                height = this.disguise.getHeight() + 1;
            }
            this.particleRot = (this.particleRot + 10.0f) % (360.0f * (float)height);
            this.spawnParticle(Math.sin(Math.toRadians(this.particleRot % 360.0f)) * (double)width, this.particleRot / 360.0f, Math.cos(Math.toRadians(this.particleRot % 360.0f)) * (double)width);
        }
    }

    public void spawnParticle(double x, double y, double z) {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177979_c(2));
        if (this.disguise != null) {
            state = this.disguise.getBottomState();
        }
        this.field_145850_b.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state).setPos(this.func_174877_v()), (double)this.func_174877_v().func_177958_n() + 0.5 + x, (double)this.func_174877_v().func_177956_o() + y, (double)this.func_174877_v().func_177952_p() + 0.5 + z, 0.0, 1.0, 0.0);
    }

    @Override
    public void placeExteriorBlocks() {
        super.placeExteriorBlocks();
        this.findDisguise();
        this.placeDisguiseBlocks();
    }

    protected void deleteDisguiseBlocks() {
        if (this.disguise != null && !this.field_145850_b.func_201670_d()) {
            BlockPos extPos = this.func_174877_v().func_185334_h();
            if (this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                Direction facing = ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d();
                for (Map.Entry<BlockPos, BlockState> entry : this.disguise.getOtherBlocks().entrySet()) {
                    BlockPos offset = entry.getKey();
                    BlockPos rotated = WorldHelper.rotateBlockPos(offset, facing);
                    BlockPos rotatedOffset = extPos.func_177971_a((Vector3i)rotated);
                    this.field_145850_b.func_180501_a(rotatedOffset, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        }
    }

    protected void placeDisguiseBlocks() {
        if (this.disguise != null && !this.field_145850_b.func_201670_d()) {
            BlockPos bottomPos;
            BlockPos extPos = this.func_174877_v().func_185334_h();
            if (this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                Direction oppositeFacing = ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d();
                for (Map.Entry<BlockPos, BlockState> entry : this.disguise.getOtherBlocks().entrySet()) {
                    BlockPos offset = entry.getKey();
                    BlockPos rotated = WorldHelper.rotateBlockPos(offset, oppositeFacing);
                    BlockPos rotatedOffset = extPos.func_177971_a((Vector3i)rotated);
                    boolean canPlace = this.field_145850_b.func_180495_p(rotatedOffset).func_196958_f();
                    if (!canPlace) continue;
                    if (entry.getValue().func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                        if (entry.getValue().func_177229_b((Property)BlockStateProperties.field_208157_J) == oppositeFacing) continue;
                        this.field_145850_b.func_180501_a(rotatedOffset, (BlockState)entry.getValue().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)oppositeFacing), 3);
                        continue;
                    }
                    if (entry.getValue().func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
                        if (entry.getValue().func_177229_b((Property)BlockStateProperties.field_208157_J) == oppositeFacing) continue;
                        this.field_145850_b.func_180501_a(rotatedOffset, (BlockState)entry.getValue().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)oppositeFacing), 3);
                        continue;
                    }
                    this.field_145850_b.func_180501_a(rotatedOffset, entry.getValue(), 3);
                }
            }
            if (this.field_145850_b.func_180495_p(bottomPos = extPos.func_177977_b()).func_185904_a().func_76222_j()) {
                this.field_145850_b.func_175656_a(bottomPos, ((Block)TBlocks.bottom_exterior.get()).func_176223_P());
            }
        }
    }

    @Override
    public void copyConsoleData(ConsoleTile console) {
        super.copyConsoleData(console);
        if (console.getExteriorManager().getDisguise() != null) {
            this.disguise = console.getExteriorManager().getDisguise();
        }
    }

    public void findDisguise() {
        if (!this.field_145850_b.func_201670_d()) {
            ChameleonSubsystem sys;
            ConsoleTile console = (ConsoleTile)((Object)TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.getInteriorDimensionKey()).orElse(null));
            if (console != null && (sys = (ChameleonSubsystem)console.getSubsystem(ChameleonSubsystem.class).orElse(null)) != null && !sys.isActiveCamo(true)) {
                return;
            }
            ArrayList<Disguise> valid = new ArrayList<Disguise>();
            for (Disguise d : DisguiseRegistry.DISGUISE_REGISTRY.get().getValues()) {
                if (!d.getIsValid(this.field_145850_b, this.func_174877_v())) continue;
                valid.add(d);
            }
            Iterator it = valid.iterator();
            block1: while (it.hasNext()) {
                Disguise d;
                d = (Disguise)((Object)it.next());
                for (BlockPos pos : d.getOtherBlocks().keySet()) {
                    BlockPos next = this.func_174877_v().func_177971_a((Vector3i)pos);
                    if (this.field_145850_b.func_180495_p(next).func_185904_a().func_76222_j()) continue;
                    it.remove();
                    continue block1;
                }
            }
            this.disguise = valid.size() > 0 ? (Disguise)((Object)valid.get(this.field_145850_b.field_73012_v.nextInt(valid.size()))) : (Disguise)DisguiseRegistry.STONE_PILLAR.get();
            TardisHelper.getConsole(this.field_145850_b.func_73046_m(), this.getInteriorDimensionKey()).ifPresent(tile -> tile.getExteriorManager().setDisguise(this.disguise));
        }
    }
}

