/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.console.misc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.misc.Console;
import net.tardis.mod.network.packets.console.UnlockData;
import net.tardis.mod.registries.ConsoleRegistry;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.tileentities.ConsoleTile;

public class UnlockManager
implements INBTSerializable<CompoundNBT> {
    public static final List<Supplier<AbstractExterior>> DEFAULT_EXTERIORS;
    private ConsoleTile tile;
    private List<Console> unlockedConsoles = Lists.newArrayList();
    private List<AbstractExterior> unlockedExteriors = Lists.newArrayList();
    private List<ConsoleRoom> unlockedConsoleRoom = Lists.newArrayList();

    public UnlockManager(ConsoleTile tile) {
        this.tile = tile;
        this.unlockedExteriors.addAll(ExteriorRegistry.getDefaultExteriors());
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT consolesList = new ListNBT();
        for (Console console : this.unlockedConsoles) {
            consolesList.add((Object)StringNBT.func_229705_a_((String)console.getRegistryName().toString()));
        }
        tag.func_218657_a("consoles", (INBT)consolesList);
        ListNBT exteriorList = new ListNBT();
        for (AbstractExterior ext : this.unlockedExteriors) {
            exteriorList.add((Object)StringNBT.func_229705_a_((String)ext.getRegistryName().toString()));
        }
        tag.func_218657_a("exteriors", (INBT)exteriorList);
        ListNBT listNBT = new ListNBT();
        for (ConsoleRoom room : this.unlockedConsoleRoom) {
            if (room.getRegistryName() == null) continue;
            listNBT.add((Object)StringNBT.func_229705_a_((String)room.getRegistryName().toString()));
        }
        tag.func_218657_a("console_rooms", (INBT)listNBT);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.unlockedExteriors.clear();
        this.unlockedConsoleRoom.clear();
        this.unlockedConsoles.clear();
        ListNBT exteriorList = tag.func_150295_c("exteriors", 8);
        for (Object nbt : exteriorList) {
            AbstractExterior ext = ExteriorRegistry.getExterior(new ResourceLocation(((StringNBT)nbt).func_150285_a_()));
            if (ext == null || this.unlockedExteriors.contains((Object)ext)) continue;
            this.unlockedExteriors.add(ext);
        }
        ListNBT roomList = tag.func_150295_c("console_rooms", 8);
        for (INBT nbt : roomList) {
            ResourceLocation key = new ResourceLocation(((StringNBT)nbt).func_150285_a_());
            ConsoleRoom room = ConsoleRoom.getRegistry().get(key);
            if (room == null) continue;
            this.unlockedConsoleRoom.add(room);
        }
        ListNBT consoleList = tag.func_150295_c("consoles", 8);
        for (INBT nbt : consoleList) {
            ResourceLocation loc = new ResourceLocation(((StringNBT)nbt).func_150285_a_());
            Console console = (Console)ConsoleRegistry.CONSOLE_REGISTRY.get().getValue(loc);
            if (console == null) continue;
            this.unlockedConsoles.add(console);
        }
    }

    public Collection<AbstractExterior> getUnlockedExteriors() {
        ArrayList newExteriorList = Lists.newArrayList(this.unlockedExteriors);
        for (Supplier<AbstractExterior> ext : DEFAULT_EXTERIORS) {
            newExteriorList.add(ext.get());
        }
        return Collections.unmodifiableCollection(newExteriorList);
    }

    public void addExterior(AbstractExterior ext) {
        if (!this.unlockedExteriors.contains((Object)ext)) {
            this.unlockedExteriors.add(ext);
        }
        this.tile.updateClient();
    }

    public void unlockAllExteriors() {
        for (AbstractExterior ext : ExteriorRegistry.EXTERIOR_REGISTRY.get().getValues()) {
            if (this.unlockedExteriors.contains((Object)ext)) continue;
            this.unlockedExteriors.add(ext);
        }
        this.tile.updateClient();
    }

    public Collection<ConsoleRoom> getUnlockedConsoleRooms() {
        return Collections.unmodifiableCollection(this.unlockedConsoleRoom);
    }

    public void addConsoleRoom(ConsoleRoom room) {
        if (!this.unlockedConsoleRoom.contains(room)) {
            this.unlockedConsoleRoom.add(room);
        }
        this.tile.updateClient();
    }

    public void clearConsoleRoomList() {
        this.unlockedConsoleRoom.clear();
        this.tile.updateClient();
    }

    public void unlockAllConsoleRooms() {
        for (ConsoleRoom room : ConsoleRoom.getRegistry().values()) {
            if (this.unlockedConsoleRoom.contains(room)) continue;
            this.unlockedConsoleRoom.add(room);
        }
        this.tile.updateClient();
    }

    public Collection<Console> getUnlockedConsoles() {
        return Collections.unmodifiableCollection(this.unlockedConsoles);
    }

    public void addConsole(Console console) {
        if (!this.unlockedConsoles.contains((Object)console)) {
            this.unlockedConsoles.add(console);
            this.tile.updateTrackingClients(new UnlockData(this));
        }
    }

    public void unlockAllConsoles() {
        for (Console consoleUnit : ConsoleRegistry.CONSOLE_REGISTRY.get().getValues()) {
            if (this.unlockedConsoles.contains((Object)consoleUnit)) continue;
            this.unlockedConsoles.add(consoleUnit);
        }
        this.tile.updateClient();
    }

    public void merge(UnlockManager manager) {
        for (Console console : manager.unlockedConsoles) {
            if (this.unlockedConsoles.contains((Object)console)) continue;
            this.unlockedConsoles.add(console);
        }
        for (ConsoleRoom interior : manager.unlockedConsoleRoom) {
            if (this.unlockedConsoleRoom.contains(interior)) continue;
            this.unlockedConsoleRoom.add(interior);
        }
        for (AbstractExterior ext : this.unlockedExteriors) {
            if (this.unlockedExteriors.contains((Object)ext)) continue;
            this.unlockedExteriors.add(ext);
        }
    }

    static {
        Object[] objectArray = new Supplier[2];
        objectArray[0] = () -> ExteriorRegistry.TT_CAPSULE.get();
        objectArray[1] = () -> ExteriorRegistry.DISGUISE.get();
        DEFAULT_EXTERIORS = Lists.newArrayList((Object[])objectArray);
    }
}

