/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.console.misc;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.tileentities.ConsoleTile;

public class PlayerTelepathicConnection
implements INBTSerializable<CompoundNBT> {
    private ConsoleTile tile;
    public UUID player;
    public int connectedTicks;

    public PlayerTelepathicConnection(ConsoleTile tile, UUID id, int connectedTicks) {
        this.player = id;
        this.connectedTicks = connectedTicks;
        this.tile = tile;
    }

    public PlayerTelepathicConnection(ConsoleTile tile, PlayerEntity player, int connectedTicks) {
        this(tile, player.func_110124_au(), connectedTicks);
    }

    public PlayerTelepathicConnection(ConsoleTile tile, CompoundNBT tag) {
        this.tile = tile;
        this.deserializeNBT(tag);
    }

    public boolean decrementAndCheckRemove(MinecraftServer server) {
        --this.connectedTicks;
        if (this.connectedTicks <= 0) {
            this.onDisconnected(server);
            return true;
        }
        return false;
    }

    public void onDisconnected(MinecraftServer server) {
        this.getPlayer(server).ifPresent(player -> player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.telepathic.not_connected"), false));
    }

    public void onSlept(MinecraftServer server) {
        this.getPlayer(server).ifPresent(player -> {
            if (this.tile != null) {
                player.func_146105_b((ITextComponent)this.tile.getEmotionHandler().getMoodState().getTranslationComponent(), false);
            }
        });
    }

    public Optional<ServerPlayerEntity> getPlayer(MinecraftServer server) {
        if (server == null || this.player == null) {
            return Optional.empty();
        }
        ServerPlayerEntity player = server.func_184103_al().func_177451_a(this.player);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_186854_a("id", this.player);
        tag.func_74768_a("ticks", this.connectedTicks);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.player = tag.func_186857_a("id");
        this.connectedTicks = tag.func_74762_e("ticks");
    }

    public UUID getPlayerId() {
        return this.player;
    }
}

