/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.console.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.tileentities.ConsoleTile;

public class MonitorOverride
implements INBTSerializable<CompoundNBT> {
    List<String> text = new ArrayList<String>();
    long timeToDisplay;

    public MonitorOverride(ConsoleTile tile, int timeToDisplay, String ... text) {
        this.timeToDisplay = (long)timeToDisplay + tile.func_145831_w().func_82737_E();
        this.text = Arrays.asList(text);
    }

    public MonitorOverride(ConsoleTile tile, int timeToDisplay, List<String> text) {
        this.timeToDisplay = (long)timeToDisplay + tile.func_145831_w().func_82737_E();
        this.text = text;
    }

    public MonitorOverride(CompoundNBT compound) {
        this.deserializeNBT(compound);
    }

    public boolean shouldRemove(ConsoleTile tile) {
        return tile.func_145831_w().func_82737_E() >= this.timeToDisplay;
    }

    public String[] getText() {
        String[] textArray = new String[this.text.size()];
        this.text.toArray(textArray);
        return textArray;
    }

    public List<String> getTextList() {
        return this.text;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74772_a("time", this.timeToDisplay);
        ListNBT text = new ListNBT();
        for (String s : this.text) {
            text.add((Object)StringNBT.func_229705_a_((String)s));
        }
        tag.func_218657_a("text", (INBT)text);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.timeToDisplay = tag.func_74763_f("time");
        ListNBT list = tag.func_150295_c("text", 8);
        list.forEach(nbt -> this.text.add(nbt.func_150285_a_()));
    }
}

