/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.tileentities.console.misc;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.ILightCap;
import net.tardis.mod.misc.ITickable;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.AlarmType;
import net.tardis.mod.tileentities.console.misc.IAlarmType;
import net.tardis.mod.tileentities.console.misc.MonitorOverride;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class InteriorManager
implements INBTSerializable<CompoundNBT>,
ITickable {
    public static ResourceLocation KEY = new ResourceLocation("tardis", "interior_manager");
    public static final int resetInteriorChangeProcessTime = 0;
    private ConsoleTile console;
    private int light = 0;
    private boolean alarm = false;
    private IAlarmType alarmType = AlarmType.CLOISTER;
    private int interiorCooldownTime = 0;
    private int interiorChangeProcessTime = 0;
    private MonitorOverride monitorOverride;

    public InteriorManager(ConsoleTile console) {
        this.console = console;
        console.registerDataHandler(KEY, this);
        console.registerTicker(this);
    }

    public int getLight() {
        return this.light;
    }

    public void setLight(int light) {
        this.light = light;
        if (!this.console.func_145831_w().func_201670_d()) {
            for (int x = -10; x < 10; ++x) {
                for (int z = -10; z < 10; ++z) {
                    ChunkPos start = this.console.func_145831_w().func_217349_x(this.console.func_174877_v()).func_76632_l();
                    ChunkPos pos = new ChunkPos(start.field_77276_a + x, start.field_77275_b + z);
                    ILightCap cap = (ILightCap)this.console.func_145831_w().func_212866_a_(pos.field_77276_a, pos.field_77275_b).getCapability(Capabilities.LIGHT).orElse(null);
                    if (cap == null) continue;
                    cap.setLight(light);
                }
            }
            ExteriorTile ext = this.console.getExteriorType().getExteriorTile(this.console);
            if (ext != null) {
                ext.setLightLevel((float)light / 15.0f);
            }
        }
    }

    public boolean canTurnOnLight() {
        return this.console.getArtron() > 0.0f;
    }

    public void setAlarmOn(boolean alarm) {
        this.alarm = alarm;
        if (alarm) {
            this.alarmType = AlarmType.CLOISTER;
        }
        this.console.updateClient();
    }

    public void soundAlarm(IAlarmType type) {
        this.setAlarmOn(true);
        this.alarmType = type;
    }

    public boolean isAlarmOn() {
        return this.alarm;
    }

    public IAlarmType getAlarmType() {
        return this.alarmType;
    }

    public int getInteriorProcessingTime() {
        return this.interiorChangeProcessTime;
    }

    public void setInteriorProcessingTime(int ticks) {
        this.interiorChangeProcessTime = ticks;
        this.console.updateClient();
    }

    public boolean isInteriorStillRegenerating() {
        return this.interiorChangeProcessTime > 0;
    }

    public boolean canChangeInteriorAgain() {
        return this.interiorCooldownTime == 0;
    }

    public void setInteriorCooldownTime(int ticks) {
        this.interiorCooldownTime = ticks;
    }

    public int getInteriorChangeTime() {
        return this.interiorCooldownTime;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("light", this.light);
        tag.func_74757_a("alarm", this.alarm);
        tag.func_74768_a("interior_process_time", this.interiorChangeProcessTime);
        tag.func_74768_a("interior_cooldown_time", this.interiorCooldownTime);
        if (this.monitorOverride != null) {
            tag.func_218657_a("override", (INBT)this.monitorOverride.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.light = nbt.func_74762_e("light");
        this.alarm = nbt.func_74767_n("alarm");
        this.interiorChangeProcessTime = nbt.func_74762_e("interior_process_time");
        this.interiorCooldownTime = nbt.func_74762_e("interior_cooldown_time");
        if (nbt.func_74764_b("override")) {
            this.monitorOverride = new MonitorOverride(nbt.func_74775_l("override"));
        }
    }

    @Override
    public void tick(ConsoleTile console) {
        if (!console.func_145831_w().field_72995_K && this.getAlarmType() != null && this.isAlarmOn() && console.func_145831_w().func_82737_E() % (long)this.getAlarmType().getLoopType() == 0L) {
            console.func_145831_w().func_184133_a(null, console.func_174877_v(), this.alarmType.getLoopSound(), SoundCategory.BLOCKS, 1.0f, 0.5f);
        }
        if (this.monitorOverride != null && this.monitorOverride.shouldRemove(console)) {
            this.monitorOverride = null;
        }
        if (!console.func_145831_w().func_201670_d() && console.shouldStartChangingInterior() && console.canStartToChangeInterior()) {
            if (this.interiorChangeProcessTime > 0) {
                --this.interiorChangeProcessTime;
            }
            if (this.interiorChangeProcessTime == 0) {
                console.handleInteriorChangeComplete();
            }
        }
        if (this.interiorCooldownTime > 0) {
            --this.interiorCooldownTime;
        }
    }

    public MonitorOverride getMonitorOverrides() {
        return this.monitorOverride;
    }

    public void setMonitorOverrides(MonitorOverride override) {
        this.monitorOverride = override;
        this.console.updateClient();
    }
}

